/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.connectors;

import com.google.gson.Gson;
import io.intino.cesar.box.schemas.Command;
import io.intino.cesar.graph.Device;
import io.intino.konos.datalake.Ness;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.command.ActiveMQBytesMessage;

public class DeviceCommander {
    private static Logger logger = Logger.getGlobal();
    private Ness datalake;
    private Device device;
    private String consulServiceTopic;

    public DeviceCommander(Ness datalake, Device device, String consulServiceTopic) {
        this.datalake = datalake;
        this.device = device;
        this.consulServiceTopic = consulServiceTopic;
    }

    public String status() {
        return this.sendCommand("status", Collections.emptyMap());
    }

    public String captureScreen() {
        return this.sendCommand("capturescreen", Collections.emptyMap());
    }

    public String screenOn() {
        return this.sendCommand("screenon", Collections.emptyMap());
    }

    public String screenOff() {
        return this.sendCommand("screenoff", Collections.emptyMap());
    }

    public String tap(final int x, final int y) {
        return this.sendCommand("tap", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("x", String.valueOf(x));
                this.put("y", String.valueOf(y));
            }
        });
    }

    public String killTask(final String packageName) {
        return this.sendCommand("killtask", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("package", packageName);
            }
        });
    }

    public String launchTask(final String packageName) {
        return this.sendCommand("launchtask", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("package", packageName);
            }
        });
    }

    public String deleteAPK(final String packageName) {
        return this.sendCommand("deleteapk", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("package", packageName);
            }
        });
    }

    public String installAPK(final String url) {
        return this.sendCommand("installapk", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("url", url);
            }
        });
    }

    public String updateAPK(final String url) {
        return this.sendCommand("updateapk", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("url", url);
            }
        });
    }

    private String sendCommand(String commandName, Map<String, String> parameters) {
        Session session = this.datalake.session();
        try {
            Thread thread = Thread.currentThread();
            String[] result = new String[]{"Error: no answer"};
            if (session == null) {
                return result[0];
            }
            MessageConsumer consumer = session.createConsumer((Destination)session.createTopic(this.consulServiceTopic + "." + this.device.alias() + ".reply"));
            consumer.setMessageListener(message -> {
                result[0] = new String(((ActiveMQBytesMessage)message).getContent().getData());
                thread.interrupt();
            });
            MessageProducer producer = session.createProducer((Destination)session.createTopic(this.consulServiceTopic + "." + this.device.alias()));
            BytesMessage message2 = session.createBytesMessage();
            Command command = new Command().operation(commandName);
            parameters.forEach(command::addAttribute);
            message2.writeBytes(new Gson().toJson((Object)command).getBytes());
            producer.send((Message)message2);
            producer.close();
            try {
                Thread.sleep((commandName.equalsIgnoreCase("capturescreen") ? 10 : 3) * 1000);
                consumer.close();
                return result[0];
            }
            catch (InterruptedException e) {
                consumer.close();
                return result[0];
            }
        }
        catch (JMSException e) {
            logger.severe(e.getMessage());
            return "Error: doing request-reply: " + e.getMessage();
        }
    }
}

