/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.actions;

import io.intino.cesar.Utils;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ChangeCommitter;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerConsul;
import io.intino.cesar.graph.System;
import io.intino.consul.ConsulJMSAccessor;
import io.intino.consul.schemas.Artifactory;
import io.intino.consul.schemas.Parameter;
import io.intino.consul.schemas.SystemSchema;
import io.intino.konos.exceptions.BadRequest;
import io.intino.konos.exceptions.Forbidden;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.jms.JMSException;
import javax.jms.Session;

public class PostDeploySystemAction {
    public String user;
    public io.intino.cesar.box.schemas.SystemSchema system;
    public CesarBox box;

    public void execute() throws BadRequest, Forbidden {
        try {
            if (!this.isAuthorized()) {
                throw new Forbidden("User '" + this.user + "' has not permissions");
            }
            ServerConsul consul = this.searchConsulCandidate();
            if (consul == null) {
                this.notifyResult("Deploying system `" + this.system.packaging().artifact() + "` on " + this.system.runtime().serverName() + ": *Consul not found*");
            }
            this.deployToConsul(consul);
        }
        catch (IOException | JMSException e) {
            Logger.getGlobal().severe(e.getMessage());
            this.notifyResult("Error deploying system. " + e.getMessage());
        }
    }

    private boolean isAuthorized() {
        return this.box.graph().responsibleList().stream().anyMatch(r -> r.username().equals(this.user));
    }

    private void notifyResult(String message) {
        this.box.cesarBot().sendToUser(this.user, message);
    }

    private ServerConsul searchConsulCandidate() {
        List servers = this.box.graph().infrastructure().unitList(u -> u.core$().is(Server.class)).stream().map(unit -> (Server)((Object)unit)).collect(Collectors.toList());
        String specificServer = this.system.runtime().serverName();
        Server selectedServer = null;
        if (specificServer != null) {
            selectedServer = servers.stream().filter(s -> specificServer.equals(s.name$())).findFirst().orElse(null);
        }
        return selectedServer == null ? null : selectedServer.serverConsul();
    }

    private void deployToConsul(ServerConsul consul) throws IOException, JMSException, Forbidden {
        Server server = (Server)consul.core$().ownerAs(Server.class);
        this.configureProxy(this.system.publicURL(), server);
        Session session = this.box.datalake().connection().createSession(false, 1);
        if (!consul.isAlive()) {
            throw new Forbidden("Consul now is offline");
        }
        ConsulJMSAccessor accessor = new ConsulJMSAccessor(session, server.alias());
        accessor.deploy(this.consulSchema(this.findSystem(), server), success -> {
            this.registerSystemOrDeploy();
            if (success.booleanValue()) {
                this.notifyResult("System " + this.system.packaging().artifact() + " has been deployed to " + server.label() + " successfully.");
            } else {
                this.notifyResult("Error deploying " + this.system.packaging().artifact() + " in " + server.label());
            }
        });
    }

    private SystemSchema consulSchema(System system, Server server) {
        SystemSchema schema = new SystemSchema();
        schema.name(Utils.normalizedID(this.system.id()));
        schema.artifact(this.system.packaging().artifact());
        schema.classpathPrefix(this.system.packaging().classpathPrefix());
        schema.parameterList(this.system.packaging().parameterList().stream().map(p -> new Parameter().name(p.name()).value(p.value())).collect(Collectors.toList()));
        schema.artifactoryList(this.system.artifactoryList().stream().map(a -> new Artifactory().id(a.id()).url(a.url()).user(a.user()).password(a.password())).collect(Collectors.toList()));
        if (system != null) {
            schema.jmxPort(Integer.valueOf(system.jmxPort()));
        } else {
            this.system.jmxPort(server.reservePort());
            schema.jmxPort(this.system.jmxPort());
        }
        return schema;
    }

    private void configureProxy(String systemURL, Server server) {
    }

    private void registerSystemOrDeploy() {
        System system = this.findSystem();
        if (system == null) {
            ChangeCommitter.commit(this.box, InfrastructureOperation.message("Add", this.user, "System", null, MessageManager.gson().toJson((Object)this.system)));
        }
        ChangeCommitter.commit(this.box, InfrastructureOperation.message("NewDeployment", this.user, "System", this.system.id(), MessageManager.gson().toJson((Object)this.system)));
    }

    private System findSystem() {
        for (System aSystem : this.box.graph().systemList()) {
            if (!aSystem.name$().equals(Utils.normalizedID(this.system.id()))) continue;
            return aSystem;
        }
        return null;
    }
}

