/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.CesarConfiguration;
import io.intino.cesar.box.messagehandlers.DeviceBootMessageHandler;
import io.intino.cesar.box.messagehandlers.DeviceCrashMessageHandler;
import io.intino.cesar.box.messagehandlers.DeviceStatusMessageHandler;
import io.intino.cesar.box.messagehandlers.DeviceUpgradeMessageHandler;
import io.intino.cesar.box.messagehandlers.InfrastructureOperationMessageHandler;
import io.intino.cesar.box.messagehandlers.ServerStatusMessageHandler;
import io.intino.cesar.box.messagehandlers.SystemLogMessageHandler;
import io.intino.cesar.box.messagehandlers.SystemStatusMessageHandler;
import io.intino.konos.jms.Consumer;
import io.intino.konos.jms.TopicConsumer;
import io.intino.ness.Inl;
import io.intino.ness.inl.Message;
import java.util.logging.Logger;

public class NessEvents {
    private static Logger logger = Logger.getGlobal();
    public static final String serverStatusTopic = "feed.consul.server.status";
    public static final String deviceStatusTopic = "feed.consul.device.status";
    public static final String deviceBootTopic = "feed.consul.device.boot";
    public static final String deviceUpgradeTopic = "feed.consul.device.upgrade";
    public static final String deviceCrashTopic = "feed.consul.device.crash";
    public static final String systemLogTopic = "feed.consul.system.log";
    public static final String systemStatusTopic = "feed.consul.system.status";
    public static final String infrastructureOperationTopic = "feed.cesar.infrastructure.operation";
    private CesarConfiguration configuration;
    private CesarBox box;

    public static void addHandlers(CesarBox box) {
        new TopicConsumer(box.datalake().session(), serverStatusTopic).listen((Consumer)new Subscriptor(box, serverStatusTopic), box.configuration().nessConfiguration().clientID + "-serverStatus");
        new TopicConsumer(box.datalake().session(), deviceStatusTopic).listen((Consumer)new Subscriptor(box, deviceStatusTopic), box.configuration().nessConfiguration().clientID + "-deviceStatus");
        new TopicConsumer(box.datalake().session(), deviceBootTopic).listen((Consumer)new Subscriptor(box, deviceBootTopic), box.configuration().nessConfiguration().clientID + "-deviceBoot");
        new TopicConsumer(box.datalake().session(), deviceUpgradeTopic).listen((Consumer)new Subscriptor(box, deviceUpgradeTopic), box.configuration().nessConfiguration().clientID + "-deviceUpgrade");
        new TopicConsumer(box.datalake().session(), deviceCrashTopic).listen((Consumer)new Subscriptor(box, deviceCrashTopic), box.configuration().nessConfiguration().clientID + "-deviceCrash");
        new TopicConsumer(box.datalake().session(), systemLogTopic).listen((Consumer)new Subscriptor(box, systemLogTopic), box.configuration().nessConfiguration().clientID + "-systemLog");
        new TopicConsumer(box.datalake().session(), systemStatusTopic).listen((Consumer)new Subscriptor(box, systemStatusTopic), box.configuration().nessConfiguration().clientID + "-systemStatus");
        new TopicConsumer(box.datalake().session(), infrastructureOperationTopic).listen((Consumer)new Subscriptor(box, infrastructureOperationTopic), box.configuration().nessConfiguration().clientID + "-infrastructureOperation");
    }

    private static class Subscriptor
    implements Consumer {
        private final CesarBox box;
        private final String topic;

        Subscriptor(CesarBox box, String topic) {
            this.box = box;
            this.topic = topic;
        }

        public void consume(javax.jms.Message message) {
            String text = this.textFrom(message);
            if (NessEvents.serverStatusTopic.equalsIgnoreCase(this.topic)) {
                ServerStatusMessageHandler messageHandler = new ServerStatusMessageHandler();
                messageHandler.box = this.box;
                messageHandler.message = (Message)Inl.load((String)text).get(0);
                messageHandler.execute();
            } else if (NessEvents.deviceStatusTopic.equalsIgnoreCase(this.topic)) {
                DeviceStatusMessageHandler messageHandler = new DeviceStatusMessageHandler();
                messageHandler.box = this.box;
                messageHandler.message = (Message)Inl.load((String)text).get(0);
                messageHandler.execute();
            } else if (NessEvents.deviceBootTopic.equalsIgnoreCase(this.topic)) {
                DeviceBootMessageHandler messageHandler = new DeviceBootMessageHandler();
                messageHandler.box = this.box;
                messageHandler.message = (Message)Inl.load((String)text).get(0);
                messageHandler.execute();
            } else if (NessEvents.deviceUpgradeTopic.equalsIgnoreCase(this.topic)) {
                DeviceUpgradeMessageHandler messageHandler = new DeviceUpgradeMessageHandler();
                messageHandler.box = this.box;
                messageHandler.message = (Message)Inl.load((String)text).get(0);
                messageHandler.execute();
            } else if (NessEvents.deviceCrashTopic.equalsIgnoreCase(this.topic)) {
                DeviceCrashMessageHandler messageHandler = new DeviceCrashMessageHandler();
                messageHandler.box = this.box;
                messageHandler.message = (Message)Inl.load((String)text).get(0);
                messageHandler.execute();
            } else if (NessEvents.systemLogTopic.equalsIgnoreCase(this.topic)) {
                SystemLogMessageHandler messageHandler = new SystemLogMessageHandler();
                messageHandler.box = this.box;
                messageHandler.message = (Message)Inl.load((String)text).get(0);
                messageHandler.execute();
            } else if (NessEvents.systemStatusTopic.equalsIgnoreCase(this.topic)) {
                SystemStatusMessageHandler messageHandler = new SystemStatusMessageHandler();
                messageHandler.box = this.box;
                messageHandler.message = (Message)Inl.load((String)text).get(0);
                messageHandler.execute();
            } else if (NessEvents.infrastructureOperationTopic.equalsIgnoreCase(this.topic)) {
                InfrastructureOperationMessageHandler messageHandler = new InfrastructureOperationMessageHandler();
                messageHandler.box = this.box;
                messageHandler.message = (Message)Inl.load((String)text).get(0);
                messageHandler.execute();
            }
        }
    }
}

