/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.intino.ness.Inl;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;

public class MessageManager {
    private static Logger logger = Logger.getGlobal();

    public static <T> List<T> fromInl(String message, Class<T> tClass) {
        try {
            if (message.startsWith("[")) {
                return Inl.deserializeAll((String)message, tClass);
            }
            return Collections.singletonList(MessageManager.gson().fromJson(message, tClass));
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.SEVERE, e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    public static String toInl(Object object) {
        return Inl.serialize((Object)object);
    }

    public static Gson gson() {
        return new GsonBuilder().registerTypeAdapter(Instant.class, (Object)new InstantAdapter()).registerTypeAdapter(Date.class, (Object)new DateAdapter()).create();
    }

    private static class DateAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.getDefault());

        private DateAdapter() {
        }

        public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
            this.df.setTimeZone(TimeZone.getTimeZone("UTC"));
            return new JsonPrimitive(this.df.format(src));
        }

        public Date deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return DatatypeConverter.parseDateTime((String)json.getAsString()).getTime();
        }
    }

    private static class InstantAdapter
    implements JsonSerializer<Instant>,
    JsonDeserializer<Instant> {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_INSTANT;

        private InstantAdapter() {
        }

        public JsonElement serialize(Instant src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(FORMATTER.format(src));
        }

        public Instant deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return FORMATTER.parse((CharSequence)json.getAsString(), Instant::from);
        }
    }
}

