/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.CesarConfiguration;
import io.intino.cesar.graph.CesarGraph;
import io.intino.konos.Box;
import io.intino.sumus.SumusStore;
import io.intino.tara.io.Stash;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Store;
import java.io.File;

public class Main {
    public static void main(String[] args) {
        CesarConfiguration configuration = new CesarConfiguration(args);
        CesarGraph cesarGraph = (CesarGraph)new Graph(Main.store(configuration)).loadStashes(new String[]{"Cesar", "Configuration", "Infrastructure", "Responsibles", "Systems"}).as(CesarGraph.class);
        if (cesarGraph.infrastructure() == null) {
            cesarGraph.create("Infrastructure", "Monentia").infrastructure().core$().save();
        }
        if (cesarGraph.configuration() == null) {
            cesarGraph.create("Configuration").configuration().core$().save();
        }
        Box box = new CesarBox(configuration).put(cesarGraph.core$()).open();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((Box)box).close()));
    }

    private static Store store(CesarConfiguration configuration) {
        return new SumusStore(new File(configuration.store().getPath())){

            public void writeStash(Stash stash, String path) {
                stash.language = stash.language == null || stash.language.isEmpty() ? "Cesar" : stash.language;
                super.writeStash(stash, path);
            }
        };
    }
}

