/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import io.intino.sumus.box.SumusConfiguration;
import java.io.File;

public class CesarConfiguration
extends SumusConfiguration {
    RestCesarConfiguration restCesarConfiguration;
    CesarBotConfiguration cesarBotConfiguration;
    NessConfiguration nessConfiguration;
    ServerStatusConfiguration serverStatusConfiguration;
    DeviceStatusConfiguration deviceStatusConfiguration;
    DeviceBootConfiguration deviceBootConfiguration;
    DeviceUpgradeConfiguration deviceUpgradeConfiguration;
    DeviceCrashConfiguration deviceCrashConfiguration;
    SystemLogConfiguration systemLogConfiguration;
    SystemStatusConfiguration systemStatusConfiguration;
    InfrastructureOperationConfiguration infrastructureOperationConfiguration;

    public CesarConfiguration(String[] args) {
        super(args);
        this.fillWithArgs();
    }

    private void fillWithArgs() {
        if (this.store == null && this.args.get("graph_store") != null) {
            this.store = new File((String)this.args.remove("graph_store"));
        }
        if (this.args.containsKey("restCesar_port")) {
            this.restCesarConfiguration(this.toInt((String)this.args.remove("restCesar_port")), (String)this.args.remove("restCesar_webDirectory"));
        }
        if (this.args.containsKey("cesarBot_token")) {
            this.cesarBotConfiguration((String)this.args.remove("cesarBot_token"));
        }
        if (this.args.containsKey("ness_url")) {
            this.nessConfiguration((String)this.args.remove("ness_url"), (String)this.args.remove("ness_user"), (String)this.args.remove("ness_password"), (String)this.args.remove("ness_clientID"));
        }
        this.setServerStatusConfiguration();
        this.setDeviceStatusConfiguration();
        this.setDeviceBootConfiguration();
        this.setDeviceUpgradeConfiguration();
        this.setDeviceCrashConfiguration();
        this.setSystemLogConfiguration();
        this.setSystemStatusConfiguration();
        this.setInfrastructureOperationConfiguration();
    }

    public File store() {
        return this.store;
    }

    public CesarConfiguration restCesarConfiguration(int port, String webDirectory) {
        this.restCesarConfiguration = new RestCesarConfiguration();
        this.restCesarConfiguration.port = port;
        this.restCesarConfiguration.webDirectory = webDirectory == null ? "www/" : webDirectory;
        return this;
    }

    public CesarConfiguration restCesarConfiguration(int port) {
        return this.restCesarConfiguration(port, "www/");
    }

    public RestCesarConfiguration restCesarConfiguration() {
        return this.restCesarConfiguration;
    }

    public CesarConfiguration cesarBotConfiguration(String token) {
        this.cesarBotConfiguration = new CesarBotConfiguration();
        this.cesarBotConfiguration.token = token;
        return this;
    }

    public CesarBotConfiguration cesarBotConfiguration() {
        return this.cesarBotConfiguration;
    }

    public CesarConfiguration nessConfiguration(String url, String user, String password, String clientID) {
        this.nessConfiguration = new NessConfiguration();
        this.nessConfiguration.url = url;
        this.nessConfiguration.user = user;
        this.nessConfiguration.password = password;
        this.nessConfiguration.clientID = clientID;
        return this;
    }

    public NessConfiguration nessConfiguration() {
        return this.nessConfiguration;
    }

    public CesarConfiguration setServerStatusConfiguration() {
        this.serverStatusConfiguration = new ServerStatusConfiguration();
        return this;
    }

    public ServerStatusConfiguration serverStatusConfiguration() {
        return this.serverStatusConfiguration;
    }

    public CesarConfiguration setDeviceStatusConfiguration() {
        this.deviceStatusConfiguration = new DeviceStatusConfiguration();
        return this;
    }

    public DeviceStatusConfiguration deviceStatusConfiguration() {
        return this.deviceStatusConfiguration;
    }

    public CesarConfiguration setDeviceBootConfiguration() {
        this.deviceBootConfiguration = new DeviceBootConfiguration();
        return this;
    }

    public DeviceBootConfiguration deviceBootConfiguration() {
        return this.deviceBootConfiguration;
    }

    public CesarConfiguration setDeviceUpgradeConfiguration() {
        this.deviceUpgradeConfiguration = new DeviceUpgradeConfiguration();
        return this;
    }

    public DeviceUpgradeConfiguration deviceUpgradeConfiguration() {
        return this.deviceUpgradeConfiguration;
    }

    public CesarConfiguration setDeviceCrashConfiguration() {
        this.deviceCrashConfiguration = new DeviceCrashConfiguration();
        return this;
    }

    public DeviceCrashConfiguration deviceCrashConfiguration() {
        return this.deviceCrashConfiguration;
    }

    public CesarConfiguration setSystemLogConfiguration() {
        this.systemLogConfiguration = new SystemLogConfiguration();
        return this;
    }

    public SystemLogConfiguration systemLogConfiguration() {
        return this.systemLogConfiguration;
    }

    public CesarConfiguration setSystemStatusConfiguration() {
        this.systemStatusConfiguration = new SystemStatusConfiguration();
        return this;
    }

    public SystemStatusConfiguration systemStatusConfiguration() {
        return this.systemStatusConfiguration;
    }

    public CesarConfiguration setInfrastructureOperationConfiguration() {
        this.infrastructureOperationConfiguration = new InfrastructureOperationConfiguration();
        return this;
    }

    public InfrastructureOperationConfiguration infrastructureOperationConfiguration() {
        return this.infrastructureOperationConfiguration;
    }

    public static class InfrastructureOperationConfiguration {
    }

    public static class SystemStatusConfiguration {
    }

    public static class SystemLogConfiguration {
    }

    public static class DeviceCrashConfiguration {
    }

    public static class DeviceUpgradeConfiguration {
    }

    public static class DeviceBootConfiguration {
    }

    public static class DeviceStatusConfiguration {
    }

    public static class ServerStatusConfiguration {
    }

    public static class NessConfiguration {
        public String url;
        public String user;
        public String password;
        public String clientID;
    }

    public static class CesarBotConfiguration {
        public String token;
    }

    public static class RestCesarConfiguration {
        public int port;
        public String webDirectory;
    }
}

