/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import io.intino.cesar.box.CesarBotSlackBot;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.CesarConfiguration;
import io.intino.cesar.box.NessEvents;
import io.intino.cesar.box.RestCesarResources;
import io.intino.cesar.box.Tasks;
import io.intino.konos.Box;
import io.intino.konos.LogFormatter;
import io.intino.konos.datalake.Ness;
import io.intino.konos.scheduling.KonosTasker;
import io.intino.konos.server.KonosSpark;
import io.intino.konos.server.activity.ActivityKonosSpark;
import io.intino.konos.slack.Bot;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.SumusConfiguration;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import spark.Spark;

public abstract class AbstractBox
extends Box {
    private static Logger LOG = Logger.getGlobal();
    protected CesarConfiguration configuration;
    private Bot cesarBot;
    private Ness ness;
    private KonosTasker tasker = new KonosTasker();

    public AbstractBox(String[] args) {
        this(new CesarConfiguration(args));
    }

    public AbstractBox(CesarConfiguration configuration) {
        this.owner = new SumusBox((SumusConfiguration)configuration);
        this.configuration = configuration;
        this.initLogger();
        ActivityKonosSpark.setup((int)this.configuration().restCesarConfiguration.port, (String)this.configuration().restCesarConfiguration.webDirectory, null);
    }

    public CesarConfiguration configuration() {
        return this.configuration;
    }

    public Box put(Object o) {
        this.owner.put(o);
        return this;
    }

    public Box open() {
        if (this.owner != null) {
            this.owner.open();
        }
        this.initActivities();
        this.initRESTServices();
        this.initJMXServices();
        this.initJMSServices();
        this.initDataLake();
        this.initTasks();
        this.initSlackBots();
        return this;
    }

    public void close() {
        if (this.owner != null) {
            this.owner.close();
        }
        Spark.stop();
        this.ness.closeSession();
    }

    public CesarBotSlackBot cesarBot() {
        return (CesarBotSlackBot)this.cesarBot;
    }

    public Ness datalake() {
        return this.ness;
    }

    public KonosTasker tasker() {
        return this.tasker;
    }

    private void initRESTServices() {
        if (this.configuration().restCesarConfiguration == null) {
            return;
        }
        RestCesarResources.setup((KonosSpark)ActivityKonosSpark.instance(), (CesarBox)this);
    }

    private void initJMSServices() {
    }

    private void initJMXServices() {
    }

    private void initSlackBots() {
        if (this.configuration().cesarBotConfiguration == null) {
            return;
        }
        this.cesarBot = new CesarBotSlackBot((CesarBox)this);
    }

    private void initActivities() {
    }

    private void initDataLake() {
        this.ness = new Ness(this.configuration().nessConfiguration().url, this.configuration().nessConfiguration().user, this.configuration().nessConfiguration().password, this.configuration().nessConfiguration().clientID);
        this.ness.start();
        NessEvents.addHandlers((CesarBox)this);
    }

    private void initTasks() {
        Tasks.init(this.tasker, (CesarBox)this);
    }

    private void initLogger() {
        Logger logger = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter((Formatter)new LogFormatter("log"));
        logger.addHandler(handler);
    }
}

