/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.exceptions.Forbidden;
import io.intino.alexandria.exceptions.Unknown;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.restaccessor.core.RestAccessor;
import io.intino.alexandria.restaccessor.core.RestAccessorNotifier;
import io.intino.alexandria.restaccessor.exceptions.RestfulFailure;
import io.intino.cesar.box.schemas.DeviceInfo;
import io.intino.cesar.box.schemas.DeviceStatus;
import io.intino.cesar.box.schemas.ProcessDeployment;
import io.intino.cesar.box.schemas.ProcessInfo;
import io.intino.cesar.box.schemas.ProcessStatus;
import io.intino.cesar.box.schemas.ProjectInfo;
import io.intino.cesar.box.schemas.ServerInfo;
import io.intino.cesar.box.schemas.ServerStatus;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class CesarRestAccessor {
    private URL url;
    private static Gson gsonReader = CesarRestAccessor.gsonReader();
    private static Gson gsonWriter = CesarRestAccessor.gsonWriter();
    private RestAccessor accessor;
    private RestAccessorNotifier notifier = new RestAccessorNotifier();
    private String token;

    public CesarRestAccessor(URL url, String token) {
        this.url = url;
        this.token = token;
        this.accessor = new RestAccessor();
    }

    public CesarRestAccessor(URL url, int timeoutMillis, String token) {
        this.url = url;
        this.token = token;
        this.accessor = new RestAccessor(timeoutMillis);
    }

    public List<ProjectInfo> getProjects() throws Unknown {
        try {
            return (List)gsonReader.fromJson(this.accessor.secure(this.url, this.token).get("//projects").content(), new TypeToken<List<ProjectInfo>>(){}.getType());
        }
        catch (RestfulFailure e) {
            throw new Unknown(e.label());
        }
    }

    public ProjectInfo getProject(String project) throws BadRequest, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return (ProjectInfo)gsonReader.fromJson(this.accessor.secure(this.url, this.token).get("//projects/" + project).content(), ProjectInfo.class);
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public List<ProcessInfo> getProcesses(String project) throws Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return (List)gsonReader.fromJson(this.accessor.secure(this.url, this.token).get("//projects/" + project + "/processes").content(), new TypeToken<List<ProcessInfo>>(){}.getType());
        }
        catch (RestfulFailure e) {
            throw new Unknown(e.label());
        }
    }

    public ProcessInfo getProcess(String project, String process) throws BadRequest, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return (ProcessInfo)gsonReader.fromJson(this.accessor.secure(this.url, this.token).get("//projects/" + project + "/processes/" + process).content(), ProcessInfo.class);
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public ProcessStatus getProcessStatus(String project, String process) throws BadRequest, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return (ProcessStatus)gsonReader.fromJson(this.accessor.secure(this.url, this.token).get("//projects/" + project + "/processes/" + process + "/status").content(), ProcessStatus.class);
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public Boolean postProcessStatus(String project, String process, final Boolean start, final Boolean debugging) throws BadRequest, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){
                {
                    if (start != null) {
                        this.put("start", String.valueOf(start));
                    }
                    if (debugging != null) {
                        this.put("debugging", String.valueOf(debugging));
                    }
                }
            };
            return Boolean.valueOf(this.accessor.secure(this.url, this.token).post("//projects/" + project + "/processes/" + process + "/status", (Map)parameters).content());
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public String getProcessLog(String project, String process) throws BadRequest, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return String.valueOf(this.accessor.secure(this.url, this.token).get("//projects/" + project + "/processes/" + process + "/log").content());
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public List<ServerInfo> getServers() throws Unknown {
        try {
            return (List)gsonReader.fromJson(this.accessor.secure(this.url, this.token).get("//servers").content(), new TypeToken<List<ServerInfo>>(){}.getType());
        }
        catch (RestfulFailure e) {
            throw new Unknown(e.label());
        }
    }

    public ServerInfo getServer(String server) throws BadRequest, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return (ServerInfo)gsonReader.fromJson(this.accessor.secure(this.url, this.token).get("//servers/" + server).content(), ServerInfo.class);
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public ServerStatus getServerStatus(String server) throws BadRequest, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return (ServerStatus)gsonReader.fromJson(this.accessor.secure(this.url, this.token).get("//servers/" + server + "/status").content(), ServerStatus.class);
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public ServerStatus getServerLog(String server) throws BadRequest, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return (ServerStatus)gsonReader.fromJson(this.accessor.secure(this.url, this.token).get("//servers/" + server + "/status").content(), ServerStatus.class);
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public List<String> getDevices() throws BadRequest, Unknown {
        try {
            return (List)gsonReader.fromJson(this.accessor.secure(this.url, this.token).get("//devices").content(), new TypeToken<ArrayList<String>>(){}.getType());
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public DeviceInfo getDevice(String device) throws BadRequest, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return (DeviceInfo)gsonReader.fromJson(this.accessor.secure(this.url, this.token).get("//devices/" + device).content(), DeviceInfo.class);
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public DeviceStatus getDeviceStatus(String device) throws BadRequest, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return (DeviceStatus)gsonReader.fromJson(this.accessor.secure(this.url, this.token).get("//devices/" + device + "/status").content(), DeviceStatus.class);
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public List<String> getDatalakeUsers() throws Unknown {
        try {
            return (List)gsonReader.fromJson(this.accessor.secure(this.url, this.token).get("//datalake/users").content(), new TypeToken<ArrayList<String>>(){}.getType());
        }
        catch (RestfulFailure e) {
            throw new Unknown(e.label());
        }
    }

    public String postDatalakeUser(String user) throws Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return String.valueOf(this.accessor.secure(this.url, this.token).post("//datalake/user/" + user).content());
        }
        catch (RestfulFailure e) {
            throw new Unknown(e.label());
        }
    }

    public String deleteDatalakeUser(String user) throws Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return String.valueOf(this.accessor.secure(this.url, this.token).delete("//datalake/user/" + user).content());
        }
        catch (RestfulFailure e) {
            throw new Unknown(e.label());
        }
    }

    public void postDeployProcess(final ProcessDeployment deployment) throws BadRequest, Forbidden, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){
                {
                    if (deployment != null) {
                        this.put("deployment", CesarRestAccessor.this.encode(String.valueOf(gsonWriter.toJson((Object)deployment))));
                    }
                }
            };
            this.accessor.secure(this.url, this.token).post("//deploy", (Map)parameters);
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            if (e.code().equals("403")) {
                throw new Forbidden(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public String postBot(final String query) throws Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){
                {
                    if (query != null) {
                        this.put("query", query);
                    }
                }
            };
            return String.valueOf(this.accessor.secure(this.url, this.token).post("//bot", (Map)parameters).content());
        }
        catch (RestfulFailure e) {
            throw new Unknown(e.label());
        }
    }

    public void listenLog(final String project, Consumer<String> listener) throws Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){
                {
                    if (project != null) {
                        this.put("project", project);
                    }
                }
            };
            this.notifier.listen(listener, this.accessor.secure(this.url, this.token).post("/log", (Map)parameters).content().trim());
        }
        catch (RestfulFailure e) {
            throw new Unknown(e.label());
        }
    }

    public void stopListenLog() {
        this.notifier.close();
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.error((String)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private static Gson gsonReader() {
        return new GsonBuilder().registerTypeAdapter(Instant.class, (json, type1, jsonDeserializationContext) -> Instant.ofEpochMilli(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(Date.class, (json, type1, jsonDeserializationContext) -> new Date(json.getAsJsonPrimitive().getAsLong())).create();
    }

    private static Gson gsonWriter() {
        return new GsonBuilder().registerTypeAdapter(Instant.class, (instant, type, context) -> new JsonPrimitive((Number)instant.toEpochMilli())).registerTypeAdapter(Date.class, (date, type, context) -> new JsonPrimitive((Number)date.getTime())).create();
    }
}

