package io.intino.cesar.box.schemas;

import io.intino.cesar.box.schemas.*;

public  class ProcessInfo implements java.io.Serializable {

	private String id;
	private String artifact;
	private String project;
	private String publicURL;
	private Server server;

	public String id() {
		return this.id;
	}

	public String artifact() {
		return this.artifact;
	}

	public String project() {
		return this.project;
	}

	public String publicURL() {
		return this.publicURL;
	}

	public Server server() {
		return this.server;
	}

	public ProcessInfo id(String id) {
		this.id = id;
		return this;
	}

	public ProcessInfo artifact(String artifact) {
		this.artifact = artifact;
		return this;
	}

	public ProcessInfo project(String project) {
		this.project = project;
		return this;
	}

	public ProcessInfo publicURL(String publicURL) {
		this.publicURL = publicURL;
		return this;
	}

	public ProcessInfo server(Server server) {
		this.server = server;
		return this;
	}

	public static class Server implements java.io.Serializable {

		private String name;
		private String ip;
		private int port = 0;

		public String name() {
			return this.name;
		}

		public String ip() {
			return this.ip;
		}

		public int port() {
			return this.port;
		}

		public Server name(String name) {
			this.name = name;
			return this;
		}

		public Server ip(String ip) {
			this.ip = ip;
			return this;
		}

		public Server port(int port) {
			this.port = port;
			return this;
		}

	}
}