package io.intino.cesar.box;

import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import java.net.URL;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.Resource;
import io.intino.alexandria.restaccessor.core.RestAccessor;
import io.intino.alexandria.restaccessor.core.RestAccessorNotifier;
import io.intino.alexandria.restaccessor.exceptions.RestfulFailure;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;

import io.intino.cesar.box.schemas.*;

public class CesarRestAccessor {
	private URL url;
	private static Gson gsonReader = gsonReader();
	private static Gson gsonWriter = gsonWriter();
	private RestAccessor accessor;
	private RestAccessorNotifier notifier = new RestAccessorNotifier();
	private String token;

	public CesarRestAccessor(URL url, String token) {
		this.url = url;
		this.token = token;
		this.accessor = new RestAccessor();
	}

	public CesarRestAccessor(URL url, int timeoutMillis, String token) {
		this.url = url;
		this.token = token;
		this.accessor = new RestAccessor(timeoutMillis);
	}

	public List<ProjectInfo> getProjects() throws Unknown {
		try {

			return gsonReader.fromJson(accessor.secure(this.url, this.token).get("/" + "/projects").content(), new TypeToken<List<ProjectInfo>>(){}.getType());
		} catch (RestfulFailure e) {
			throw new Unknown(e.label());
		}
	}

	public ProjectInfo getProject(String project) throws BadRequest, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{

			}};
			return gsonReader.fromJson(accessor.secure(this.url, this.token).get("/" + "/projects" + "/" + project).content(), ProjectInfo.class);
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			throw new Unknown(e.label());
		}
	}

	public List<ProcessInfo> getProcesses(String project) throws Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{

			}};
			return gsonReader.fromJson(accessor.secure(this.url, this.token).get("/" + "/projects" + "/" + project + "/processes").content(), new TypeToken<List<ProcessInfo>>(){}.getType());
		} catch (RestfulFailure e) {
			throw new Unknown(e.label());
		}
	}

	public ProcessInfo getProcess(String project, String process) throws BadRequest, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{


			}};
			return gsonReader.fromJson(accessor.secure(this.url, this.token).get("/" + "/projects" + "/" + project + "/processes" + "/" + process).content(), ProcessInfo.class);
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			throw new Unknown(e.label());
		}
	}

	public ProcessStatus getProcessStatus(String project, String process) throws BadRequest, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{


			}};
			return gsonReader.fromJson(accessor.secure(this.url, this.token).get("/" + "/projects" + "/" + project + "/processes" + "/" + process + "/status").content(), ProcessStatus.class);
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			throw new Unknown(e.label());
		}
	}

	public Boolean postProcessStatus(String project, String process, Boolean start, Boolean debugging) throws BadRequest, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{


				if (start != null) put("start", String.valueOf(start));
				if (debugging != null) put("debugging", String.valueOf(debugging));
			}};
			return Boolean.valueOf(accessor.secure(this.url, this.token).post("/" + "/projects" + "/" + project + "/processes" + "/" + process + "/status", parameters).content());
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			throw new Unknown(e.label());
		}
	}

	public String getProcessLog(String project, String process) throws BadRequest, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{


			}};
			return String.valueOf(accessor.secure(this.url, this.token).get("/" + "/projects" + "/" + project + "/processes" + "/" + process + "/log").content());
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			throw new Unknown(e.label());
		}
	}

	public List<ServerInfo> getServers() throws Unknown {
		try {

			return gsonReader.fromJson(accessor.secure(this.url, this.token).get("/" + "/servers").content(), new TypeToken<List<ServerInfo>>(){}.getType());
		} catch (RestfulFailure e) {
			throw new Unknown(e.label());
		}
	}

	public ServerInfo getServer(String server) throws BadRequest, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{

			}};
			return gsonReader.fromJson(accessor.secure(this.url, this.token).get("/" + "/servers" + "/" + server).content(), ServerInfo.class);
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			throw new Unknown(e.label());
		}
	}

	public ServerStatus getServerStatus(String server) throws BadRequest, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{

			}};
			return gsonReader.fromJson(accessor.secure(this.url, this.token).get("/" + "/servers" + "/" + server + "/status").content(), ServerStatus.class);
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			throw new Unknown(e.label());
		}
	}

	public ServerStatus getServerLog(String server) throws BadRequest, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{

			}};
			return gsonReader.fromJson(accessor.secure(this.url, this.token).get("/" + "/servers" + "/" + server + "/status").content(), ServerStatus.class);
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			throw new Unknown(e.label());
		}
	}

	public List<String> getDevices() throws BadRequest, Unknown {
		try {

			return gsonReader.fromJson(accessor.secure(this.url, this.token).get("/" + "/devices").content(), new TypeToken<ArrayList<String>>(){}.getType());
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			throw new Unknown(e.label());
		}
	}

	public DeviceInfo getDevice(String device) throws BadRequest, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{

			}};
			return gsonReader.fromJson(accessor.secure(this.url, this.token).get("/" + "/devices" + "/" + device).content(), DeviceInfo.class);
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			throw new Unknown(e.label());
		}
	}

	public DeviceStatus getDeviceStatus(String device) throws BadRequest, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{

			}};
			return gsonReader.fromJson(accessor.secure(this.url, this.token).get("/" + "/devices" + "/" + device + "/status").content(), DeviceStatus.class);
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			throw new Unknown(e.label());
		}
	}

	public List<String> getDatalakeUsers() throws Unknown {
		try {

			return gsonReader.fromJson(accessor.secure(this.url, this.token).get("/" + "/datalake" + "/users").content(), new TypeToken<ArrayList<String>>(){}.getType());
		} catch (RestfulFailure e) {
			throw new Unknown(e.label());
		}
	}

	public String postDatalakeUser(String user) throws Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{

			}};
			return String.valueOf(accessor.secure(this.url, this.token).post("/" + "/datalake" + "/user" + "/" + user).content());
		} catch (RestfulFailure e) {
			throw new Unknown(e.label());
		}
	}

	public String deleteDatalakeUser(String user) throws Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{

			}};
			return String.valueOf(accessor.secure(this.url, this.token).delete("/" + "/datalake" + "/user" + "/" + user).content());
		} catch (RestfulFailure e) {
			throw new Unknown(e.label());
		}
	}

	public void postDeployProcess(ProcessDeployment deployment) throws BadRequest, Forbidden, Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{
				if (deployment != null) put("deployment", encode(String.valueOf(gsonWriter.toJson(deployment))));
			}};
			accessor.secure(this.url, this.token).post("/" + "/deploy", parameters);
		} catch (RestfulFailure e) {
			if (e.code().equals("400")) throw new BadRequest(e.label());
			else if (e.code().equals("403")) throw new Forbidden(e.label());
			throw new Unknown(e.label());
		}
	}

	public String postBot(String query) throws Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{
				if (query != null) put("query", query);
			}};
			return String.valueOf(accessor.secure(this.url, this.token).post("/" + "/bot", parameters).content());
		} catch (RestfulFailure e) {
			throw new Unknown(e.label());
		}
	}

	public void listenLog(String project, java.util.function.Consumer<String> listener) throws Unknown {
		try {
			java.util.Map<String, String> parameters = new java.util.HashMap<String, String>() {{
				if (project != null) put("project", project);
			}};
			this.notifier.listen(listener, accessor.secure(this.url, this.token).post("/log", parameters).content().trim());
		} catch (RestfulFailure e) {
			throw new Unknown(e.label());
		}
	}

	public void stopListenLog() {
		this.notifier.close();
	}

	private String encode(String value) {
		try {
			return java.net.URLEncoder.encode(value, "UTF-8");
		} catch (java.io.UnsupportedEncodingException e) {
			io.intino.alexandria.logger.Logger.error(e.getMessage(), e);
			return "";
		}
	}

	private static Gson gsonReader() {
        return new GsonBuilder().
            registerTypeAdapter(java.time.Instant.class, (com.google.gson.JsonDeserializer<java.time.Instant>) (json, type1, jsonDeserializationContext) -> java.time.Instant.ofEpochMilli(json.getAsJsonPrimitive().getAsLong())).
            registerTypeAdapter(java.util.Date.class, (com.google.gson.JsonDeserializer<java.util.Date>) (json, type1, jsonDeserializationContext) -> new java.util.Date(json.getAsJsonPrimitive().getAsLong())).
            create();
	}

	private static Gson gsonWriter() {
        return new GsonBuilder().
            registerTypeAdapter(java.time.Instant.class, (com.google.gson.JsonSerializer<java.time.Instant>) (instant, type, context) -> new com.google.gson.JsonPrimitive(instant.toEpochMilli())).
            registerTypeAdapter(java.util.Date.class, (com.google.gson.JsonSerializer<java.util.Date>) (date, type, context) -> new com.google.gson.JsonPrimitive(date.getTime())).
            create();
    }
}