/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import com.google.gson.reflect.TypeToken;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.exceptions.Forbidden;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.restaccessor.OutBox;
import io.intino.alexandria.restaccessor.RequestBuilder;
import io.intino.alexandria.restaccessor.Response;
import io.intino.alexandria.restaccessor.adapters.ResponseAdapter;
import io.intino.alexandria.restaccessor.core.RestAccessorNotifier;
import io.intino.cesar.box.schemas.DeviceInfo;
import io.intino.cesar.box.schemas.DeviceStatus;
import io.intino.cesar.box.schemas.ProcessDeployment;
import io.intino.cesar.box.schemas.ProcessInfo;
import io.intino.cesar.box.schemas.ProcessStatus;
import io.intino.cesar.box.schemas.ServerInfo;
import io.intino.cesar.box.schemas.ServerStatus;
import java.io.File;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ApiAccessor {
    private final URL url;
    private final RestAccessorNotifier notifier = new RestAccessorNotifier();
    private int timeoutMillis = 120000;
    private OutBox outBox = null;
    private final String token;

    public ApiAccessor(URL url, String token) {
        this.url = url;
        this.token = token;
    }

    public ApiAccessor(URL url, int timeoutMillis, String token) {
        this.url = url;
        this.timeoutMillis = timeoutMillis;
        this.token = token;
    }

    public ApiAccessor(URL url, int timeoutMillis, File outBoxDirectory, int intervalRetrySeconds, String token) {
        this.url = url;
        this.timeoutMillis = timeoutMillis;
        this.outBox = new OutBox(outBoxDirectory, intervalRetrySeconds);
        this.token = token;
    }

    public List<ProcessInfo> getProcesses(String server) throws InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).bearerAuth(this.token).build(RequestBuilder.Method.GET, "//servers/" + server + "/processes");
        try {
            Response response = request.execute();
            return (List)ResponseAdapter.adapt((String)response.content(), (Type)new TypeToken<ArrayList<ProcessInfo>>(){}.getType());
        }
        catch (AlexandriaException e) {
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public ProcessInfo getProcess(String server, String process) throws BadRequest, InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).bearerAuth(this.token).build(RequestBuilder.Method.GET, "//servers/" + server + "/processes/" + process);
        try {
            Response response = request.execute();
            return (ProcessInfo)ResponseAdapter.adapt((String)response.content(), ProcessInfo.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof BadRequest) {
                throw (BadRequest)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public ProcessStatus getProcessStatus(String server, String process) throws BadRequest, InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).bearerAuth(this.token).build(RequestBuilder.Method.GET, "//servers/" + server + "/processes/" + process + "/status");
        try {
            Response response = request.execute();
            return (ProcessStatus)ResponseAdapter.adapt((String)response.content(), ProcessStatus.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof BadRequest) {
                throw (BadRequest)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public Boolean postProcessStatus(String server, String process, Boolean start, Boolean debugging) throws BadRequest, InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).bearerAuth(this.token).queryParameter("start", (Object)start).queryParameter("debugging", (Object)debugging).build(RequestBuilder.Method.POST, "//servers/" + server + "/processes/" + process + "/status");
        try {
            Response response = request.execute();
            return (Boolean)ResponseAdapter.adapt((String)response.content(), Boolean.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof BadRequest) {
                throw (BadRequest)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public String getProcessLog(String server, String process, Integer page) throws BadRequest, InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).bearerAuth(this.token).queryParameter("page", (Object)page).build(RequestBuilder.Method.GET, "//servers/" + server + "/processes/" + process + "/log");
        try {
            Response response = request.execute();
            return (String)ResponseAdapter.adapt((String)response.content(), String.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof BadRequest) {
                throw (BadRequest)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public List<ServerInfo> getServers() throws InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).bearerAuth(this.token).build(RequestBuilder.Method.GET, "//servers");
        try {
            Response response = request.execute();
            return (List)ResponseAdapter.adapt((String)response.content(), (Type)new TypeToken<ArrayList<ServerInfo>>(){}.getType());
        }
        catch (AlexandriaException e) {
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public ServerInfo getServer(String server) throws BadRequest, InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).bearerAuth(this.token).build(RequestBuilder.Method.GET, "//servers/" + server);
        try {
            Response response = request.execute();
            return (ServerInfo)ResponseAdapter.adapt((String)response.content(), ServerInfo.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof BadRequest) {
                throw (BadRequest)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public ServerStatus getServerStatus(String server) throws BadRequest, InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).bearerAuth(this.token).build(RequestBuilder.Method.GET, "//servers/" + server + "/status");
        try {
            Response response = request.execute();
            return (ServerStatus)ResponseAdapter.adapt((String)response.content(), ServerStatus.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof BadRequest) {
                throw (BadRequest)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public ServerStatus getServerLog(String server) throws BadRequest, InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).bearerAuth(this.token).build(RequestBuilder.Method.GET, "//servers/" + server + "/status");
        try {
            Response response = request.execute();
            return (ServerStatus)ResponseAdapter.adapt((String)response.content(), ServerStatus.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof BadRequest) {
                throw (BadRequest)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public List<String> getDevices() throws BadRequest, InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).bearerAuth(this.token).build(RequestBuilder.Method.GET, "//devices");
        try {
            Response response = request.execute();
            return (List)ResponseAdapter.adapt((String)response.content(), (Type)new TypeToken<ArrayList<String>>(){}.getType());
        }
        catch (AlexandriaException e) {
            if (e instanceof BadRequest) {
                throw (BadRequest)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public DeviceInfo getDevice(String device) throws BadRequest, InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).bearerAuth(this.token).build(RequestBuilder.Method.GET, "//devices/" + device);
        try {
            Response response = request.execute();
            return (DeviceInfo)ResponseAdapter.adapt((String)response.content(), DeviceInfo.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof BadRequest) {
                throw (BadRequest)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public DeviceStatus getDeviceStatus(String device) throws BadRequest, InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).bearerAuth(this.token).build(RequestBuilder.Method.GET, "//devices/" + device + "/status");
        try {
            Response response = request.execute();
            return (DeviceStatus)ResponseAdapter.adapt((String)response.content(), DeviceStatus.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof BadRequest) {
                throw (BadRequest)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public void postDeployProcess(ProcessDeployment deployment) throws BadRequest, Forbidden, InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).bearerAuth(this.token).queryParameter("deployment", (Object)deployment).build(RequestBuilder.Method.POST, "//deploy");
        try {
            Response response = request.execute();
        }
        catch (AlexandriaException e) {
            if (e instanceof BadRequest) {
                throw (BadRequest)e;
            }
            if (e instanceof Forbidden) {
                throw (Forbidden)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public String postBot(String query, String timeZone) throws InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).bearerAuth(this.token).queryParameter("query", (Object)query).queryParameter("timeZone", (Object)timeZone).build(RequestBuilder.Method.POST, "//bot");
        try {
            Response response = request.execute();
            return (String)ResponseAdapter.adapt((String)response.content(), String.class);
        }
        catch (AlexandriaException e) {
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public void listenLog(String process, Consumer<String> listener) throws InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).bearerAuth(this.token).queryParameter("process", (Object)process).build(RequestBuilder.Method.POST, "/log");
        try {
            this.notifier.listen(listener, request.execute().content().trim());
        }
        catch (AlexandriaException e) {
            throw new InternalServerError(e.message());
        }
    }

    public void stopListenLog() {
        this.notifier.close();
    }

    public void listenBotNotifications(String user, Consumer<String> listener) throws InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).bearerAuth(this.token).queryParameter("user", (Object)user).build(RequestBuilder.Method.POST, "/bot/notifications");
        try {
            this.notifier.listen(listener, request.execute().content().trim());
        }
        catch (AlexandriaException e) {
            throw new InternalServerError(e.message());
        }
    }

    public void stopListenBotNotifications() {
        this.notifier.close();
    }
}

