/*
 * Decompiled with CFR 0.152.
 */
package io.intino.builderservice.konos.runner;

import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.SELContext;
import com.github.dockerjava.api.model.Volume;
import io.intino.builderservice.konos.BuilderStore;
import io.intino.builderservice.konos.runner.ContainerManager;
import io.intino.builderservice.konos.runner.ProjectDirectory;
import io.intino.builderservice.konos.runner.RunConfigurationRenderer;
import io.intino.builderservice.konos.schemas.BuilderInfo;
import io.intino.builderservice.konos.schemas.RunOperationContext;
import io.intino.builderservice.konos.utils.Tar;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.AbstractMap;
import java.util.List;
import java.util.UUID;

public class BuilderRunner {
    public static final String REPOSITORY_BIND = "/app/.m2/repository";
    private final BuilderStore store;
    private final ContainerManager manager;
    private final File workspace;
    private final File languagesRepository;

    public BuilderRunner(BuilderStore store, ContainerManager manager, File workspace, File languagesRepository) {
        this.store = store;
        this.manager = manager;
        this.workspace = workspace;
        this.languagesRepository = languagesRepository;
    }

    public AbstractMap.SimpleEntry<String, List<File>> run(RunOperationContext params, InputStream tarSources) throws IOException {
        BuilderInfo info = this.store.get(params.imageURL());
        String ticket = UUID.randomUUID().toString();
        ProjectDirectory hostProject = ProjectDirectory.of(this.workspace.getCanonicalFile(), ticket);
        List<File> srcFiles = BuilderRunner.moveFiles(tarSources, hostProject.root());
        List<String> srcPaths = this.mapPaths(srcFiles, hostProject);
        ProjectDirectory containerProject = new ProjectDirectory(new File("/project"));
        RunConfigurationRenderer renderer = new RunConfigurationRenderer(params, containerProject, srcPaths, new File(REPOSITORY_BIND));
        Files.writeString(hostProject.argsFile().toPath().toAbsolutePath(), (CharSequence)renderer.build(), new OpenOption[0]);
        String container = this.manager.createContainer(info.imageURL(), ticket, new Bind(hostProject.root().getCanonicalFile().getAbsolutePath(), new Volume("/project"), AccessMode.rw, SELContext.single), new Bind(this.languagesRepository.getAbsolutePath(), new Volume(REPOSITORY_BIND), AccessMode.rw, SELContext.single));
        this.manager.start(container);
        return new AbstractMap.SimpleEntry<String, List<File>>(ticket, srcFiles);
    }

    private List<String> mapPaths(List<File> srcFiles, ProjectDirectory projectDir) {
        return srcFiles.stream().map(File::getAbsolutePath).map(projectDir.directoryMapper()).toList();
    }

    private static List<File> moveFiles(InputStream tar, File projectDir) throws IOException {
        File src = new File(projectDir, "src");
        src.mkdirs();
        return Tar.unTar(tar, src);
    }
}

