/*
 * Decompiled with CFR 0.152.
 */
package io.intino.builderservice.konos;

import com.google.gson.reflect.TypeToken;
import io.intino.alexandria.Json;
import io.intino.alexandria.logger.Logger;
import io.intino.builderservice.konos.runner.ContainerManager;
import io.intino.builderservice.konos.schemas.BuilderInfo;
import io.intino.builderservice.konos.schemas.RegisterBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BuilderStore {
    private final File indexFile;
    private final Map<String, BuilderInfo> index;
    private final ContainerManager dockerManager;

    public BuilderStore(ContainerManager dockerManager, File directory) {
        this.dockerManager = dockerManager;
        directory.mkdirs();
        this.indexFile = new File(directory, "builders.json");
        this.index = this.load(this.indexFile);
    }

    public Collection<BuilderInfo> all() {
        return this.index.values();
    }

    private Map<String, BuilderInfo> load(File index) {
        try {
            if (!index.exists()) {
                return new HashMap<String, BuilderInfo>();
            }
            return (Map)Json.fromJson((Reader)new FileReader(index), (Type)new TypeToken<HashMap<String, BuilderInfo>>(this){}.getType());
        }
        catch (FileNotFoundException e) {
            Logger.error((Throwable)e);
            return new HashMap<String, BuilderInfo>();
        }
    }

    public void put(RegisterBuilder info) {
        try {
            this.dockerManager.download(info.imageURL(), info.registryToken());
            this.index.put(info.imageURL(), new BuilderInfo().imageURL(info.imageURL()));
            this.saveIndex();
        }
        catch (IOException | InterruptedException e) {
            Logger.error((Throwable)e);
        }
    }

    public synchronized void saveIndex() {
        try {
            Files.writeString(this.indexFile.toPath(), (CharSequence)Json.toJson(this.index), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public BuilderInfo get(String builderId) {
        return this.index.get(builderId);
    }
}

