/*
 * Decompiled with CFR 0.152.
 */
package io.intino.builderservice.konos;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.http.AlexandriaHttpServerBuilder;
import io.intino.builderservice.konos.BuilderServiceBox;
import io.intino.builderservice.konos.BuilderServiceConfiguration;
import io.intino.builderservice.konos.BuilderServiceService;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends Box {
    protected BuilderServiceConfiguration configuration;

    public AbstractBox(String[] args) {
        this(new BuilderServiceConfiguration(args));
    }

    public AbstractBox(BuilderServiceConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
    }

    public BuilderServiceConfiguration configuration() {
        return this.configuration;
    }

    public Box put(Object o) {
        return this;
    }

    public abstract void beforeStart();

    public Box start() {
        this.initConnector();
        if (this.owner != null) {
            this.owner.beforeStart();
        }
        this.beforeStart();
        if (this.owner != null) {
            this.owner.startServices();
        }
        this.startServices();
        if (this.owner != null) {
            this.owner.afterStart();
        }
        this.afterStart();
        return this;
    }

    public abstract void afterStart();

    public abstract void beforeStop();

    public void stop() {
        if (this.owner != null) {
            this.owner.beforeStop();
        }
        this.beforeStop();
        if (this.owner != null) {
            this.owner.stopServices();
        }
        this.stopServices();
        if (this.owner != null) {
            this.owner.afterStop();
        }
        this.afterStop();
    }

    public void stopServices() {
        AlexandriaHttpServerBuilder.instance().stop();
    }

    public abstract void afterStop();

    public void startServices() {
        this.initUI();
        this.initAgenda();
        this.initRestServices();
        this.initSoapServices();
        this.initJmxServices();
        this.initTerminal();
        this.initMessagingServices();
        this.initSentinels();
        this.initSlackBots();
        this.initWorkflow();
        this.initCli();
    }

    private void initRestServices() {
        if (this.configuration().get("port") == null || this.configuration().get("port").isEmpty()) {
            return;
        }
        AlexandriaHttpServerBuilder.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/", (long)Long.parseLong("104857600"));
        BuilderServiceService.setup(AlexandriaHttpServerBuilder.instance(), (BuilderServiceBox)this);
        AlexandriaHttpServerBuilder.instance().start();
        io.intino.alexandria.logger.Logger.info((String)("Rest service builder-service: started at port " + this.configuration().get("port") + "!"));
    }

    private void initSoapServices() {
    }

    private void initMessagingServices() {
    }

    private void initJmxServices() {
    }

    private void initSlackBots() {
    }

    private void initUI() {
    }

    protected void initConnector() {
    }

    protected void initTerminal() {
    }

    protected void initSentinels() {
    }

    protected void initWorkflow() {
    }

    protected void initAgenda() {
    }

    protected void initCli() {
    }

    protected void initJavaLogger() {
        Logger Logger2 = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter((Formatter)new io.intino.alexandria.logger.Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
        io.intino.alexandria.logger4j.Logger.init();
    }

    public static URL url(String url) {
        try {
            return new URI(url).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            return null;
        }
    }
}

