/*
 * Decompiled with CFR 0.152.
 */
package io.intino.builderservice.konos.utils;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class Tar {
    public static List<File> unTar(InputStream tarFile, File destDir) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream(tarFile);){
            TarArchiveEntry entry;
            while ((entry = tarIn.getNextTarEntry()) != null) {
                File outputFile = new File(destDir, entry.getName());
                if (entry.isDirectory()) {
                    outputFile.mkdirs();
                    continue;
                }
                if (new File(entry.getName()).getName().startsWith(".")) continue;
                outputFile.getParentFile().mkdirs();
                try (FileOutputStream out = new FileOutputStream(outputFile);){
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = tarIn.read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, len);
                    }
                }
                files.add(outputFile.getCanonicalFile());
            }
        }
        return files;
    }

    public static void tar(File sourceDir, FileFilter filter, File tarFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(tarFile);
             TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)fos);){
            for (File f : Objects.requireNonNull(sourceDir.listFiles())) {
                Tar.addFileToTar(tarOut, f, "", filter);
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private static void addFileToTar(TarArchiveOutputStream tarOut, File file, String base, FileFilter filter) throws IOException {
        if (!filter.accept(file)) {
            return;
        }
        String entryName = base + file.getName();
        TarArchiveEntry tarEntry = new TarArchiveEntry(file, entryName);
        tarOut.putArchiveEntry(tarEntry);
        if (file.isFile()) {
            try (FileInputStream fis = new FileInputStream(file);){
                IOUtils.copy((InputStream)fis, (OutputStream)tarOut);
            }
            tarOut.closeArchiveEntry();
        } else if (file.isDirectory()) {
            tarOut.closeArchiveEntry();
            File[] children = file.listFiles(filter);
            if (children != null) {
                for (File child : children) {
                    Tar.addFileToTar(tarOut, child, entryName + "/", filter);
                }
            }
        }
    }
}

