/*
 * Decompiled with CFR 0.152.
 */
package io.intino.builderservice.konos.runner;

import io.intino.builderservice.konos.runner.ProjectDirectory;
import io.intino.builderservice.konos.schemas.RunOperationContext;
import io.intino.itrules.formatters.StringFormatters;
import java.io.File;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.List;

public class RunConfigurationRenderer {
    private static final char NL = '\n';
    private final RunOperationContext params;
    private final ProjectDirectory project;
    private final List<String> srcFiles;
    private final File languagesRepository;

    public RunConfigurationRenderer(RunOperationContext params, ProjectDirectory project, List<String> srcFiles, File languagesRepository) {
        this.params = params;
        this.project = project;
        this.srcFiles = srcFiles;
        this.languagesRepository = languagesRepository;
    }

    public String build() {
        StringWriter writer = new StringWriter();
        writer.write("def.file\n");
        this.srcFiles.stream().map(file -> file + "#true\n").forEach(writer::write);
        writer.write(10);
        writer.write("project\n" + this.params.projectName() + "\n");
        writer.write("module\n" + this.params.projectName() + "\n");
        writer.write("artifactId\n" + this.normalize(this.params.projectName()).toLowerCase() + "\n");
        writer.write("groupId\n" + this.normalize(this.params.projectGroup()).toLowerCase() + "\n");
        this.writePaths(writer);
        writer.write("make\ntrue\n");
        writer.write("test.module\nfalse\n");
        writer.write("encoding\n" + Charset.defaultCharset().name() + "\n");
        if (this.params.operation().equalsIgnoreCase("check")) {
            writer.write("excluded_phases\n8,9\n");
        }
        writer.write("generation.package\n" + (this.normalize(this.params.generationPackage()).isEmpty() ? "model" : this.normalize(this.params.generationPackage())) + "\n");
        if (this.params.operation().equalsIgnoreCase("check")) {
            writer.write("compilation.mode\nBuild\n");
        } else {
            writer.write("compilation.mode\n" + this.params.operation() + "\n");
        }
        if (!this.params.projectVersion().isEmpty()) {
            writer.write("version\n" + this.params.projectVersion() + "\n");
        }
        writer.write("dsl\n" + String.join((CharSequence)":", this.params.languageGroup(), this.params.languageName(), this.params.languageVersion()) + "\n");
        writer.write("out.dsl\n" + this.params.projectName() + "\n");
        return writer.toString();
    }

    private String normalize(String name) {
        return StringFormatters.camelCase().format((Object)name).toString();
    }

    private void writePaths(StringWriter writer) {
        writer.write("project.path\n" + this.project.root().getAbsolutePath() + "\n");
        writer.write("module.path\n" + this.project.root().getAbsolutePath() + "\n");
        writer.write("outputpath\n" + this.project.gen().getAbsolutePath() + "\n");
        writer.write("final_outputpath\n" + this.project.out().getAbsolutePath() + "\n");
        writer.write("res.path\n" + String.valueOf(this.project.res()) + "\n");
        writer.write("repository.path\n" + this.languagesRepository.getPath() + "\n");
        writer.write("src.path\n");
        writer.write(this.project.src().getAbsolutePath());
        writer.write(10);
        writer.write(10);
    }
}

