/*
 * Decompiled with CFR 0.152.
 */
package io.intino.builderservice.konos.actions;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.exceptions.NotFound;
import io.intino.alexandria.http.server.AlexandriaHttpContext;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.rest.RequestErrorHandler;
import io.intino.builderservice.konos.BuilderServiceBox;
import io.intino.builderservice.konos.rest.resources.GetOutputResourceResource;
import io.intino.builderservice.konos.runner.ProjectDirectory;
import io.intino.builderservice.konos.utils.Tar;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;

public class GetOutputResourceAction
implements RequestErrorHandler {
    public GetOutputResourceResource.Output output;
    public BuilderServiceBox box;
    public AlexandriaHttpContext context;
    public String ticket;
    public String excludeFilePattern;

    public Resource execute() throws NotFound, InternalServerError {
        ProjectDirectory directory = ProjectDirectory.of(this.box.workspace(), this.ticket);
        if (!directory.exists()) {
            throw new NotFound("Ticket does not exist");
        }
        File file = GetOutputResourceAction.tempFile();
        FileFilter filter = this.excludeFilePattern != null ? new NotFileFilter((IOFileFilter)new RegexFileFilter(this.excludeFilePattern)) : f -> true;
        try {
            switch (this.output) {
                case Gen: {
                    if (this.emptyIfNull(directory.gen().listFiles()).length == 0) {
                        throw new NotFound("Directory is empty");
                    }
                    Tar.tar(directory.gen(), filter, file);
                    break;
                }
                case Src: {
                    if (this.emptyIfNull(directory.src().listFiles()).length == 0) {
                        throw new NotFound("Directory is empty");
                    }
                    Tar.tar(directory.src(), filter, file);
                    break;
                }
                case Res: {
                    if (this.emptyIfNull(directory.res().listFiles()).length == 0) {
                        throw new NotFound("Directory is empty");
                    }
                    Tar.tar(directory.res(), filter, file);
                    break;
                }
                case Out: {
                    if (this.emptyIfNull(directory.out().listFiles()).length == 0) {
                        throw new NotFound("Directory is empty");
                    }
                    Tar.tar(directory.out(), filter, file);
                    break;
                }
                case Build: {
                    if (this.emptyIfNull(directory.build().listFiles()).length == 0) {
                        throw new NotFound("Directory is empty");
                    }
                    Tar.tar(directory.build(), filter, file);
                    break;
                }
                default: {
                    throw new NotFound("Output not found: " + String.valueOf((Object)this.output));
                }
            }
            return new Resource("file", file);
        }
        catch (IOException e) {
            throw new InternalServerError(e.getMessage());
        }
    }

    private File[] emptyIfNull(File[] files) {
        return files == null ? new File[]{} : files;
    }

    private static File tempFile() {
        try {
            return Files.createTempFile("output", ".tar", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public void onMalformedRequest(Throwable e) throws AlexandriaException {
        throw new BadRequest("Malformed request");
    }
}

