/*
 * Decompiled with CFR 0.152.
 */
package io.intino.builder;

import io.intino.Configuration;
import io.intino.builder.BuildConstants;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class CompilerConfiguration {
    private static final Logger LOG = Logger.getGlobal();
    private int warningLevel;
    private String sourceEncoding;
    private String project;
    private String module;
    private boolean test;
    private String parentInterface;
    private boolean debug;
    private final List<File> sources = new ArrayList<File>();
    private File srcDirectory;
    private File genDirectory;
    private File resDirectory;
    private File outDirectory;
    private String groupID;
    private String artifactID;
    private String version;
    private final DslConfiguration dsl;
    private boolean verbose;
    private File tempDirectory;
    private File datahubLibrary;
    private List<String> currentDependencies;
    private File intinoProjectDirectory;
    private String generationPackage;
    private PrintStream out = System.out;
    private File projectDirectory;
    private File webModuleDirectory;
    private File archetypeLibrary;
    private File serviceDirectory;
    private File configurationDirectory;
    private List<String> parameters = new ArrayList<String>();
    private BuildConstants.Mode mode = BuildConstants.Mode.Build;
    private final List<Configuration.Repository> repositories = new ArrayList<Configuration.Repository>();
    private Configuration.Repository releaseDistributionRepository;
    private Configuration.Repository snapshotDistributionRepository;
    private File localRepository;
    private Phase invokedBuildPhase;
    private final List<Integer> excludedInternalSteps = new ArrayList<Integer>();

    public CompilerConfiguration() {
        this.setWarningLevel(1);
        this.setDebug(false);
        String encoding = System.getProperty("file.encoding", "UTF8");
        encoding = System.getProperty("tara.source.encoding", encoding);
        this.sourceEncoding(encoding);
        this.dsl = new DslConfiguration();
        this.localRepository = new File(String.join((CharSequence)File.separator, System.getProperty("user.home"), ".m2", "repository"));
        try {
            this.tempDirectory = Files.createTempDirectory("_intino_", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public int getWarningLevel() {
        return this.warningLevel;
    }

    public void setWarningLevel(int level) {
        this.warningLevel = level < 0 || level > 3 ? 1 : level;
    }

    public String sourceEncoding() {
        return this.sourceEncoding;
    }

    public void sourceEncoding(String encoding) {
        if (encoding == null) {
            this.sourceEncoding = "UTF8";
        }
        this.sourceEncoding = encoding;
    }

    public Phase invokedPhase() {
        return this.invokedBuildPhase;
    }

    public CompilerConfiguration invokedPhase(Phase phase) {
        this.invokedBuildPhase = phase;
        return this;
    }

    public List<Integer> excludedInternalSteps() {
        return this.excludedInternalSteps;
    }

    public void addExcludedInternalSteps(List<Integer> steps) {
        this.excludedInternalSteps.addAll(steps);
    }

    public void addRepository(Configuration.Repository repository) {
        this.repositories.add(repository);
    }

    public List<Configuration.Repository> repositories() {
        return this.repositories;
    }

    public File localRepository() {
        return this.localRepository;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    public void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public CompilerConfiguration localRepository(File localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    public boolean test() {
        return this.test;
    }

    public void test(boolean b) {
        this.test = b;
    }

    public String project() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String groupId() {
        return this.groupID;
    }

    public void groupId(String groupID) {
        this.groupID = groupID;
    }

    public String artifactId() {
        return this.artifactID;
    }

    public void artifactId(String artifactID) {
        this.artifactID = artifactID;
    }

    public String version() {
        return this.version;
    }

    public void version(String version) {
        this.version = version;
    }

    public void generationPackage(String generationPackage) {
        this.generationPackage = generationPackage;
    }

    public String generationPackage() {
        return this.generationPackage;
    }

    public String module() {
        return this.module;
    }

    public void module(String module) {
        this.module = module;
    }

    public DslConfiguration dsl() {
        return this.dsl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void intinoProjectDirectory(File intinoPath) {
        this.intinoProjectDirectory = intinoPath;
    }

    public File intinoProjectDirectory() {
        return this.intinoProjectDirectory;
    }

    public List<File> sources() {
        return this.sources;
    }

    public File srcDirectory() {
        return this.srcDirectory;
    }

    public void srcDirectory(File srcDirectory) {
        this.srcDirectory = srcDirectory;
    }

    public void genDirectory(File directory) {
        if (directory != null) {
            this.genDirectory = directory;
            this.genDirectory.mkdirs();
        }
    }

    public File genDirectory() {
        return this.genDirectory;
    }

    public File rulesDirectory() {
        String rulesPackage = (this.generationPackage() == null ? this.module.toLowerCase() : this.generationPackage().toLowerCase().replace(".", File.separator)) + File.separator + "rules";
        File file = new File(this.srcDirectory, rulesPackage);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public File functionsDirectory() {
        String functionsPackage = (this.generationPackage() == null ? this.module.toLowerCase() : this.generationPackage().toLowerCase().replace(".", File.separator)) + File.separator + "functions";
        File file = new File(this.srcDirectory, functionsPackage);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    @Deprecated
    public File webModuleDirectory() {
        return this.webModuleDirectory;
    }

    public File moduleDirectory() {
        return this.serviceDirectory;
    }

    public File projectDirectory() {
        return this.projectDirectory;
    }

    @Deprecated
    public void webModuleDirectory(File serviceDirectory) {
        this.webModuleDirectory = serviceDirectory;
    }

    public void moduleDirectory(File moduleDirectory) {
        this.serviceDirectory = moduleDirectory;
    }

    public void projectDirectory(File projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public File configurationDirectory() {
        return this.configurationDirectory;
    }

    public CompilerConfiguration configurationDirectory(File configurationDirectory) {
        this.configurationDirectory = configurationDirectory;
        return this;
    }

    public File resDirectory() {
        return this.resDirectory;
    }

    public void resDirectory(File resDirectory) {
        this.resDirectory = resDirectory;
    }

    public File outDirectory() {
        return this.outDirectory;
    }

    public PrintStream out() {
        return this.out;
    }

    public void out(PrintStream out) {
        this.out = out;
    }

    public String parentInterface() {
        return this.parentInterface;
    }

    public void parentInterface(String parentInterface) {
        this.parentInterface = parentInterface;
    }

    public File datahubLibrary() {
        return this.datahubLibrary;
    }

    public void datahubLibrary(File datahubLibrary) {
        this.datahubLibrary = datahubLibrary;
    }

    public File archetypeLibrary() {
        return this.archetypeLibrary;
    }

    public void archetypeLibrary(File archetypeLibrary) {
        this.archetypeLibrary = archetypeLibrary;
    }

    public void parameters(String[] parameters) {
        this.parameters = List.of(parameters);
    }

    public List<String> parameters() {
        return this.parameters;
    }

    public void outDirectory(File file) {
        this.outDirectory = file;
    }

    public void mode(String mode) {
        this.mode = BuildConstants.Mode.valueOf(mode);
    }

    public BuildConstants.Mode mode() {
        return this.mode;
    }

    public List<String> currentDependencies() {
        return this.currentDependencies == null ? Collections.emptyList() : this.currentDependencies;
    }

    public CompilerConfiguration currentDependencies(List<String> currentDependencies) {
        this.currentDependencies = currentDependencies;
        return this;
    }

    public Configuration.Repository releaseDistributionRepository() {
        return this.releaseDistributionRepository;
    }

    public CompilerConfiguration releaseDistributionRepository(Configuration.Repository repository) {
        this.releaseDistributionRepository = repository;
        return this;
    }

    public Configuration.Repository snapshotDistributionRepository() {
        return this.snapshotDistributionRepository;
    }

    public CompilerConfiguration snapshotDistributionRepository(Configuration.Repository repository) {
        this.snapshotDistributionRepository = repository;
        return this;
    }

    public CompilerConfiguration clone() {
        try {
            return (CompilerConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.info(e.getMessage());
            return null;
        }
    }

    static {
        Logger.getGlobal().setLevel(Level.INFO);
        LOG.setUseParentHandlers(false);
        for (Handler handler : LOG.getHandlers()) {
            LOG.removeHandler(handler);
        }
        StreamHandler errorHandler = new StreamHandler(System.err, new SimpleFormatter());
        errorHandler.setLevel(Level.WARNING);
        LOG.addHandler(errorHandler);
        StreamHandler infoHandler = new StreamHandler(System.out, new SimpleFormatter());
        infoHandler.setLevel(Level.INFO);
        LOG.addHandler(infoHandler);
    }

    public static class DslConfiguration {
        private String groupId = "tara.dsl";
        private String artifactId;
        private String version;
        private Configuration.Artifact.Dsl.Level level;
        private String outDsl;
        private final Library runtime = new Library();
        private final Library builder = new Library();
        private String generationPackage;

        public String artifactId() {
            return this.artifactId;
        }

        public void outDsl(String outDsl) {
            this.outDsl = outDsl;
        }

        public String outDsl() {
            return this.outDsl;
        }

        public DslConfiguration artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public DslConfiguration version(String version) {
            this.version = version;
            return this;
        }

        public Library runtime() {
            return this.runtime;
        }

        public Library builder() {
            return this.builder;
        }

        public String version() {
            return this.version;
        }

        @Deprecated
        public void level(Configuration.Artifact.Dsl.Level level) {
            this.level = level;
        }

        @Deprecated
        public Configuration.Artifact.Dsl.Level level() {
            return this.level;
        }

        public String generationPackage() {
            return this.generationPackage;
        }

        public void generationPackage(String generationPackage) {
            this.generationPackage = generationPackage;
        }

        public String groupId() {
            return this.groupId;
        }

        public DslConfiguration groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }
    }

    public static enum Phase {
        COMPILE,
        PACKAGE,
        INSTALL,
        DISTRIBUTE;

    }

    public static class Library {
        private String groupId;
        private String artifactId;
        private String version;

        public String groupId() {
            return this.groupId;
        }

        public String artifactId() {
            return this.artifactId;
        }

        public String version() {
            return this.version;
        }

        public Library groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Library artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Library version(String version) {
            this.version = version;
            return this;
        }
    }
}

