/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.shared;

import io.intino.amidas.shared.Team;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class Identity
implements Iterable<Team.Statement> {
    protected final String id;
    protected List<Team.Statement> statements;

    public Identity() {
        this(UUID.randomUUID().toString(), new ArrayList<Team.Statement>());
    }

    public Identity(String id, List<Team.Statement> statements) {
        this.id = id;
        this.statements = statements;
    }

    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    public String id() {
        return this.id;
    }

    public Team.Statement get(String property) {
        return this.statements.stream().filter(s -> s.has(property)).findFirst().orElse(null);
    }

    public List<Team.Statement> search(String property) {
        return this.statements.stream().filter(s -> s.has(property)).collect(Collectors.toList());
    }

    public Team.Id getId(String name) {
        Team.Statement statement = this.get("id/" + name);
        return statement != null ? new Team.Id(statement) : null;
    }

    public Team.Feature getFeature(String name) {
        Team.Statement statement = this.get("feature/" + name);
        return statement != null ? new Team.Feature(statement) : null;
    }

    public Team.Credential getCredential(String name) {
        Team.Statement statement = this.get("credential/" + name);
        return statement != null ? new Team.Credential(statement) : null;
    }

    public Team.Role getRole(String name) {
        Team.Statement statement = this.get("role/" + name);
        return statement != null ? new Team.Role(statement) : null;
    }

    public List<Team.Id> ids() {
        return this.ids("");
    }

    public List<Team.Id> ids(String type) {
        return this.statements.stream().filter(s -> s.has("id/" + type)).map(Team.Id::new).collect(Collectors.toList());
    }

    public List<Team.Feature> features() {
        return this.features("");
    }

    public List<Team.Feature> features(String type) {
        return this.statements.stream().filter(s -> s.has("feature/" + type)).map(Team.Feature::new).collect(Collectors.toList());
    }

    public List<Team.Credential> credentials() {
        return this.credentials("");
    }

    public List<Team.Credential> credentials(String type) {
        return this.statements.stream().filter(s -> s.has("credential/" + type)).map(Team.Credential::new).collect(Collectors.toList());
    }

    public List<Team.Role> roles() {
        return this.roles("");
    }

    public List<Team.Role> roles(String type) {
        return this.statements.stream().filter(s -> s.has("role/" + type)).map(Team.Role::new).collect(Collectors.toList());
    }

    public Identity append(Team.Definition definition) {
        this.appendStatement(definition);
        return this;
    }

    public Identity appendAll(List<Team.Definition> definitionList) {
        definitionList.forEach(this::appendStatement);
        return this;
    }

    public Identity append(final String property, final String value) {
        return this.append(new Team.Definition(){

            @Override
            public String property() {
                return property;
            }

            @Override
            public String value() {
                return value;
            }
        });
    }

    @Override
    public Iterator<Team.Statement> iterator() {
        return this.statements.iterator();
    }

    public String toString() {
        return "[" + this.id + "]\n" + this.statements.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }

    public boolean equals(Object object) {
        return this == object || this.isIdentity(object) && this.id.equals(((Identity)object).id);
    }

    private boolean isIdentity(Object object) {
        return object != null && this.getClass() == object.getClass();
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    protected Team.Statement appendStatement(Team.Definition definition) {
        Team.Statement statement = new Team.Statement(definition.property(), definition.value());
        this.statementOf(statement.property()).ifPresent(s -> this.statements.remove(s));
        this.statements.add(statement);
        return statement;
    }

    private Optional<Team.Statement> statementOf(String property) {
        return this.statements.stream().filter(s -> s.has(property)).findFirst();
    }
}

