/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.connectors.microsoft.teams;

import com.microsoft.bot.builder.Bot;
import com.microsoft.bot.connector.authentication.MicrosoftAppCredentials;
import com.microsoft.bot.integration.AdapterWithErrorHandler;
import com.microsoft.bot.integration.BotFrameworkHttpAdapter;
import com.microsoft.bot.integration.Configuration;
import io.intino.alexandria.http.AlexandriaSpark;
import io.intino.alexandria.logger.Logger;
import io.intino.amidas.connectors.microsoft.teams.BotController;
import io.intino.amidas.connectors.microsoft.teams.ConfigurationKeys;
import io.intino.amidas.connectors.microsoft.teams.ProxyBot;
import io.intino.amidas.connectors.microsoft.teams.TeamsInfo;
import io.intino.amidas.connectors.microsoft.teams.model.Team;
import io.intino.amidas.shared.Team;
import io.intino.amidas.shared.connectors.MessagingConnector;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.naming.ConfigurationException;

public class TeamsConnector
implements MessagingConnector {
    private final Properties configuration;
    private BotController botController;
    private ProxyBot bot;
    private MicrosoftAppCredentials credentials;
    private List<Team> teams;
    private io.intino.amidas.shared.Team team;

    public TeamsConnector(Properties configuration) {
        this.configuration = configuration;
    }

    public void setup(AlexandriaSpark spark) throws ConfigurationException {
        block3: {
            block2: {
                if (this.configuration == null) break block2;
                if (ConfigurationKeys.keys().allMatch(this.configuration::containsKey)) break block3;
            }
            throw new ConfigurationException("Expected the next keys in configuration: " + String.join((CharSequence)", ", (CharSequence[])ConfigurationKeys.keys().toArray(String[]::new)));
        }
        AdapterWithErrorHandler adapter = new AdapterWithErrorHandler(this.microsoftConfiguration());
        this.credentials = this.credentials();
        this.bot = new ProxyBot(this.credentials, this.configuration, (BotFrameworkHttpAdapter)adapter);
        this.botController = new BotController(spark, (BotFrameworkHttpAdapter)adapter, (Bot)this.bot);
    }

    public void start(io.intino.amidas.shared.Team team) {
        this.team = team;
        this.scheduleReloadTeams();
        this.botController.start();
    }

    public boolean sendMessage(String user, String message) {
        Team.Identity identity = this.identity(user);
        if (identity == null) {
            Logger.error((String)("User '" + user + "' not found in identities"));
            return false;
        }
        if (message.isEmpty()) {
            Logger.error((String)"Notification empty");
            return false;
        }
        Logger.info((String)("Trying to notify " + message + " to " + user));
        try {
            return this.bot.sendMessageToUser(identity.get("id/username").value(), message);
        }
        catch (IllegalArgumentException e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    public boolean sendMessage(String teamName, String channelName, String message) {
        if (message.isEmpty()) {
            Logger.error((String)"Notification empty");
            return false;
        }
        Logger.info((String)("Trying to notify " + message + " to " + teamName + " -> " + channelName));
        try {
            Team.Channel channel = this.channel(teamName, channelName);
            return this.bot.sendMessageToChannel(channel.id(), message);
        }
        catch (IllegalArgumentException e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    private Team.Channel channel(String team, String channel) {
        if (team == null) {
            throw new IllegalArgumentException("Team not found");
        }
        return this.teams.stream().filter(tm -> tm.displayName().equals(team)).findFirst().orElseThrow(() -> new IllegalArgumentException("Team " + team + " not found")).channels().stream().filter(c -> c.displayName().equals(channel)).findFirst().orElseThrow(() -> new IllegalArgumentException("Channel " + channel + " not found"));
    }

    private Configuration microsoftConfiguration() {
        return new Configuration(){
            private static final Map<String, String> PropertyMapper = Map.of("MicrosoftAppId", "clientId", "MicrosoftAppPassword", "clientSecret", "MicrosoftAppTenant", "tenantId");

            public String getProperty(String s) {
                return TeamsConnector.this.configuration.getProperty(PropertyMapper.getOrDefault(s, s));
            }

            public Properties getProperties() {
                Properties properties = new Properties();
                properties.put("MicrosoftAppId", properties.getProperty("federation.connectors.microsoft.teams.clientId"));
                properties.put("MicrosoftAppPassword", properties.getProperty("federation.connectors.microsoft.teams.clientSecret"));
                properties.put("MicrosoftAppTenant", properties.getProperty("federation.connectors.microsoft.teams.tenantId"));
                properties.put("server.port", properties.getProperty("federation.port"));
                return properties;
            }

            public String[] getProperties(String s) {
                return this.getProperties().stringPropertyNames().toArray(new String[0]);
            }
        };
    }

    private MicrosoftAppCredentials credentials() {
        return new MicrosoftAppCredentials(this.configuration.getProperty("federation.connectors.microsoft.teams.clientId"), this.configuration.getProperty("federation.connectors.microsoft.teams.clientSecret"), this.configuration.getProperty("federation.connectors.microsoft.teams.tenantId"));
    }

    private void scheduleReloadTeams() {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(() -> {
            List<Team> newTeams = new TeamsInfo(this.credentials).reloadTeams();
            this.teams.clear();
            this.teams.addAll(newTeams);
        }, 0L, 1L, TimeUnit.HOURS);
        this.teams = new TeamsInfo(this.credentials).reloadTeams();
    }

    private Team.Identity identity(String user) {
        List result = this.team.search("id/username", user);
        if (result.isEmpty()) {
            result = this.team.search("id/email", user);
        }
        return !result.isEmpty() ? (Team.Identity)result.get(0) : null;
    }
}

