/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.connectors.microsoft.teams;

import com.codepoetics.protonpack.collectors.CompletableFutures;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.bot.builder.MessageFactory;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.builder.teams.TeamsActivityHandler;
import com.microsoft.bot.connector.authentication.MicrosoftAppCredentials;
import com.microsoft.bot.integration.BotFrameworkHttpAdapter;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.Attachment;
import com.microsoft.bot.schema.ChannelAccount;
import com.microsoft.bot.schema.ConversationParameters;
import com.microsoft.bot.schema.ConversationReference;
import io.intino.alexandria.Json;
import io.intino.alexandria.cli.schemas.BotResponse;
import io.intino.alexandria.cli.schemas.BotTalk;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.restaccessor.Response;
import io.intino.alexandria.restaccessor.RestAccessor;
import io.intino.alexandria.restaccessor.core.RestAccessor;
import io.intino.alexandria.restaccessor.exceptions.RestfulFailure;
import io.intino.amidas.connectors.microsoft.teams.ConversationReferences;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public class ProxyBot
extends TeamsActivityHandler {
    private final MicrosoftAppCredentials credentials;
    private final Properties configuration;
    private final ConversationReferences conversations;
    private final BotFrameworkHttpAdapter adapter;

    public ProxyBot(MicrosoftAppCredentials credentials, Properties configuration, BotFrameworkHttpAdapter adapter) {
        this.credentials = credentials;
        this.configuration = configuration;
        this.adapter = adapter;
        this.conversations = this.loadConversations();
    }

    public boolean sendMessageToUser(String user, String message) {
        if (this.conversations.isEmpty()) {
            Logger.error((String)"There aren't conversations");
            return false;
        }
        ConversationReference ref = this.conversations.values().stream().filter(c -> user.equals(c.getUser().getAadObjectId())).findFirst().orElse(null);
        if (ref == null) {
            return false;
        }
        this.adapter.continueConversation(this.credentials.getAppId(), ref, ctx -> ctx.sendActivity(message).thenApply(resourceResponse -> null));
        return true;
    }

    public boolean sendMessageToChannel(String channelId, String message) {
        if (this.conversations.isEmpty()) {
            Logger.error((String)"There aren't conversations");
            return false;
        }
        ConversationReference conv = this.conversations.values().stream().filter(c -> !c.getServiceUrl().contains("botframework.com")).findFirst().orElse((ConversationReference)this.conversations.values().iterator().next());
        Logger.info((String)("Sending notification to " + channelId + ": " + message));
        this.adapter.createConversation(channelId, conv.getServiceUrl(), this.credentials, ProxyBot.notificationParameters(channelId, conv.getBot(), MessageFactory.text((String)message)), null).thenApply(started -> null);
        return true;
    }

    protected CompletableFuture<Void> onConversationUpdateActivity(TurnContext context) {
        Logger.info((String)"Updated conversation activity");
        this.addConversationReference(context.getActivity());
        return super.onConversationUpdateActivity(context);
    }

    protected CompletableFuture<Void> onMembersAdded(List<ChannelAccount> membersAdded, TurnContext context) {
        this.addConversationReference(context.getActivity());
        String welcomeText = "Hello and welcome!";
        return ((CompletableFuture)membersAdded.stream().filter(member -> !StringUtils.equals((CharSequence)member.getId(), (CharSequence)context.getActivity().getRecipient().getId())).map(channel -> context.sendActivity(MessageFactory.text((String)welcomeText, (String)welcomeText, null))).collect(CompletableFutures.toFutureList())).thenApply(resourceResponses -> null);
    }

    protected CompletableFuture<Void> onMessageActivity(TurnContext context) {
        try {
            BotResponse response;
            this.addConversationReference(context.getActivity());
            String user = this.user(context);
            String request = context.getActivity().getText();
            Logger.debug((String)("request: " + request));
            if (this.isMention(request)) {
                request = this.cleanMention(request);
            }
            if ((response = this.queryApp(context, user, request)).type().equals((Object)BotResponse.Type.text)) {
                return this.sendTextResponse(context, response);
            }
            if (response.type().equals((Object)BotResponse.Type.question)) {
                return this.sendQuestionResponse(context, response);
            }
            if (response.type().equals((Object)BotResponse.Type.multiline)) {
                return this.sendMultilineResponse(context, response);
            }
            return this.sendFile(response);
        }
        catch (AlexandriaException | RestfulFailure e) {
            Logger.error((String)e.getMessage());
            return context.sendActivity("Error processing request: " + e.getMessage()).thenApply(r -> null);
        }
    }

    private CompletableFuture<Void> sendQuestionResponse(TurnContext context, BotResponse response) {
        Activity activity = MessageFactory.suggestedActions((List)response.options(), (String)response.title());
        activity.getSuggestedActions().setTo(List.of(context.getActivity().getFrom().getId()));
        return context.sendActivity(activity).thenApply(sendResult -> null);
    }

    private CompletableFuture<Void> sendTextResponse(TurnContext context, BotResponse botResponse) {
        return context.sendActivity(MessageFactory.text((String)this.format(botResponse.raw()))).thenApply(result -> null);
    }

    private CompletableFuture<Void> sendMultilineResponse(TurnContext context, BotResponse botResponse) {
        return context.sendActivity(MessageFactory.text((String)this.format(botResponse.raw()))).thenApply(result -> null);
    }

    private String format(String text) {
        return text.replace("\n", "\n\n").replace(":+1:", "&#x1F44D;").replace(":cpu:", "&#x26CF;").replace(":memory:", "&#x1F4C0;").replace(":small_red_triangle:", "&#x1F53C;").replace(":small_red_triangle_down:", "&#x1F53D;").replace(":hdd:", "&#x1F4BE;").replace(":clock10:", "&#x1F551;").replace(":threads:", "&#x1F9F5;").replace(":network:", "&#x1F310;").replace(":started:", "&#x1F7E2;").replace(":stop:", "&#x1F534;");
    }

    private CompletableFuture<Void> sendFile(BotResponse response) {
        return ((CompletableFuture)((CompletableFuture)this.getInlineAttachment(response).thenApply(attachment -> {
            Activity reply = MessageFactory.text((String)"This is an inline attachment.");
            reply.setAttachment(attachment);
            return reply;
        })).exceptionally(ex -> MessageFactory.text((String)("There was an error handling the attachment: " + ex.getMessage())))).thenCompose(r -> null);
    }

    private BotResponse queryApp(TurnContext context, String userId, String messageContent) throws AlexandriaException, RestfulFailure {
        RestAccessor.RestfulSecureConnection restAccessor = new RestAccessor().secure(this.urlOf(this.configuration.getProperty("federation.connectors.microsoft.teams.app.url")), userId);
        BotTalk talk = new BotTalk().conversation(messageContent).timeZone(context.getActivity().getLocalTimezone());
        Response post = restAccessor.post(this.configuration.getProperty("federation.connectors.microsoft.teams.app.cliPath"), Json.toJson((Object)talk));
        return (BotResponse)Json.fromJson((String)post.content(), BotResponse.class);
    }

    private URL urlOf(String url) {
        try {
            return new URI(url).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private CompletableFuture<Attachment> getInlineAttachment(BotResponse response) {
        return CompletableFuture.completedFuture(response.raw()).thenApply(encodedFileData -> {
            Attachment attachment = new Attachment();
            attachment.setName(response.fileName());
            attachment.setContentType("image/png");
            attachment.setContentUrl("data:image/png;base64," + encodedFileData);
            return attachment;
        });
    }

    private String cleanMention(String request) {
        return request.replace("<at>" + this.configuration.getProperty("federation.connectors.microsoft.teams.botName") + "</at>", "").trim();
    }

    private boolean isMention(String request) {
        return request.startsWith("<at>" + this.configuration.getProperty("federation.connectors.microsoft.teams.botName") + "</at>");
    }

    private void addConversationReference(Activity activity) {
        ConversationReference ref = activity.getConversationReference();
        this.conversations.put(ref.getUser().getId(), ref);
        this.saveConversationReferences();
    }

    private ConversationReferences loadConversations() {
        try {
            Path path = this.conversationsFile();
            if (!path.toFile().exists()) {
                return new ConversationReferences();
            }
            return (ConversationReferences)Json.fromString((String)Files.readString(path), ConversationReferences.class);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return new ConversationReferences();
        }
    }

    private Path conversationsFile() {
        String storeDir = this.configuration.getProperty("federation.connectors.microsoft.teams.store.directory");
        new File(storeDir).mkdirs();
        return new File(storeDir, "conversations.json").toPath();
    }

    private static ConversationParameters notificationParameters(String channel, ChannelAccount bot, Activity message) {
        ObjectNode channelData = JsonNodeFactory.instance.objectNode();
        channelData.set("channel", JsonNodeFactory.instance.objectNode().set("id", (JsonNode)JsonNodeFactory.instance.textNode(channel)));
        ConversationParameters params = new ConversationParameters();
        params.setIsGroup(true);
        params.setBot(bot);
        params.setActivity(message);
        params.setChannelData((Object)channelData);
        return params;
    }

    private void saveConversationReferences() {
        try {
            Files.writeString(this.conversationsFile(), (CharSequence)String.join((CharSequence)"\n", Json.toString((Object)this.conversations)), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private String user(TurnContext context) {
        return context.getActivity().getFrom().getAadObjectId();
    }
}

