/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.connectors.microsoft.teams;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.microsoft.bot.builder.Bot;
import com.microsoft.bot.connector.authentication.AuthenticationException;
import com.microsoft.bot.integration.BotFrameworkHttpAdapter;
import com.microsoft.bot.schema.Activity;
import io.intino.alexandria.http.AlexandriaSpark;
import io.intino.alexandria.logger.Logger;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;

public class BotController {
    private final AlexandriaSpark spark;
    private final BotFrameworkHttpAdapter adapter;
    private final Bot bot;
    private final Gson gson = new GsonBuilder().registerTypeAdapter(OffsetDateTime.class, BotController.offsetDateTime()).registerTypeAdapter(LocalDateTime.class, BotController.localDateTime()).create();

    public BotController(AlexandriaSpark spark, BotFrameworkHttpAdapter withAdapter, Bot bot) {
        this.spark = spark;
        this.adapter = withAdapter;
        this.bot = bot;
    }

    public void start() {
        this.spark.route("api/messages").post(manager -> {
            try {
                CompletableFuture<Response> future = this.incoming((Activity)this.gson.fromJson(manager.body(), Activity.class), manager.fromHeaderOrDefault("Authorization", ""));
                Response response = future.get();
                manager.response().body(response.body);
                manager.response().status(response.code);
            }
            catch (InterruptedException | ExecutionException e) {
                Logger.error((Throwable)e);
            }
        });
    }

    public CompletableFuture<Response> incoming(Activity activity, String authHeader) {
        return this.adapter.processIncomingActivity(authHeader, activity, this.bot).handle((result, exception) -> {
            if (exception == null) {
                return result != null ? new Response(result.getBody().toString(), result.getStatus()) : new Response("", 200);
            }
            exception.printStackTrace();
            if (exception instanceof CompletionException) {
                return exception.getCause() instanceof AuthenticationException ? new Response("Unauthorized", 401) : new Response("Exception handling message: " + exception.getMessage(), 500);
            }
            return new Response("Exception handling message: " + exception.getMessage(), 500);
        });
    }

    private static JsonDeserializer<OffsetDateTime> offsetDateTime() {
        return (json, type1, context) -> OffsetDateTime.parse(json.getAsString());
    }

    private static JsonDeserializer<LocalDateTime> localDateTime() {
        return (json, type1, context) -> LocalDateTime.parse(json.getAsString());
    }

    public record Response(String body, int code) {
    }
}

