/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.connectors.microsoft.teams;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.microsoft.bot.connector.authentication.MicrosoftAppCredentials;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AadUserConversationMember;
import com.microsoft.graph.models.Channel;
import com.microsoft.graph.models.ConversationMember;
import com.microsoft.graph.models.Group;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ChannelCollectionPage;
import com.microsoft.graph.requests.ChannelCollectionRequest;
import com.microsoft.graph.requests.ConversationMemberCollectionPage;
import com.microsoft.graph.requests.ConversationMemberCollectionRequest;
import com.microsoft.graph.requests.ConversationMemberCollectionResponse;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.GroupCollectionPage;
import com.microsoft.graph.requests.GroupCollectionRequest;
import com.microsoft.graph.requests.TeamCollectionRequest;
import io.intino.alexandria.logger.Logger;
import io.intino.amidas.connectors.microsoft.teams.model.Member;
import io.intino.amidas.connectors.microsoft.teams.model.Team;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;

public class TeamsInfo {
    private final MicrosoftAppCredentials credentials;

    public TeamsInfo(MicrosoftAppCredentials credentials) {
        this.credentials = credentials;
    }

    public List<Team> reloadTeams() {
        GraphServiceClient<Request> graphClient = this.client();
        GroupCollectionPage response = (GroupCollectionPage)((GroupCollectionRequest)graphClient.groups().buildRequest(new Option[0])).get();
        return this.map(response.getCurrentPage(), graphClient);
    }

    public void createTeam(String name, List<String> users) {
        com.microsoft.graph.models.Team team = new com.microsoft.graph.models.Team();
        team.additionalDataManager().put((Object)"template@odata.bind", (Object)new JsonPrimitive("https://graph.microsoft.com/v1.0/teamsTemplates('standard')"));
        team.displayName = name;
        team.description = name;
        AadUserConversationMember members = new AadUserConversationMember();
        members.roles = List.of("owner");
        members.additionalDataManager().put((Object)"user@odata.bind", (Object)new JsonPrimitive("https://graph.microsoft.com/v1.0/users('0040b377-61d8-43db-94f5-81374122dc7e')"));
        ConversationMemberCollectionResponse conversationMemberCollectionResponse = new ConversationMemberCollectionResponse();
        conversationMemberCollectionResponse.value = List.of(members);
        team.members = new ConversationMemberCollectionPage(conversationMemberCollectionResponse, null);
        ((TeamCollectionRequest)this.client().teams().buildRequest(new Option[0])).post(team);
        this.addMembers(users);
    }

    private void addMembers(List<String> users) {
        LinkedList<AadUserConversationMember> valuesList = new LinkedList<AadUserConversationMember>();
        for (String user : users) {
            AadUserConversationMember values = new AadUserConversationMember();
            values.roles = List.of(user);
            values.additionalDataManager().put((Object)"user@odata.bind", (Object)new JsonPrimitive("https://graph.microsoft.com/v1.0/users('18a80140-b0fb-4489-b360-2f6efaf225a0')"));
            valuesList.add(values);
        }
        ConversationMemberCollectionResponse conversationMemberCollectionResponse = new ConversationMemberCollectionResponse();
        conversationMemberCollectionResponse.value = valuesList;
        ConversationMemberCollectionPage conversationMemberCollectionPage = new ConversationMemberCollectionPage(conversationMemberCollectionResponse, null);
    }

    private List<Member> extractMembers(GraphServiceClient<Request> graphClient, List<Team> teams) {
        ArrayList<Member> members = new ArrayList<Member>();
        for (Team team : teams) {
            members.addAll(this.map(((ConversationMemberCollectionPage)((ConversationMemberCollectionRequest)graphClient.teams(team.id).members().buildRequest(new Option[0])).get()).getCurrentPage()));
        }
        return members;
    }

    private List<Member> map(List<ConversationMember> page) {
        return page.stream().map((? super T m) -> new Member(m.id, m.displayName)).collect(Collectors.toList());
    }

    private List<Team> map(List<Group> groups, GraphServiceClient<Request> client) {
        ArrayList<Team> teams = new ArrayList<Team>();
        for (Group group : groups) {
            if (!TeamsInfo.isTeamsGroup(group)) continue;
            List<Channel> channels = TeamsInfo.channels(client, group);
            teams.add(new Team(group.id, group.displayName, channels.stream().map((? super T c) -> new Team.Channel(c.id, c.displayName)).collect(Collectors.toList())));
        }
        return teams;
    }

    private static boolean isTeamsGroup(Group group) {
        JsonElement element = (JsonElement)group.additionalDataManager().get((Object)"resourceProvisioningOptions");
        if (element == null) {
            return false;
        }
        for (JsonElement e : element.getAsJsonArray()) {
            if (!e.getAsString().equals("Team")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<Channel> channels(GraphServiceClient<Request> client, Group group) {
        List list;
        try {
            list = ((ChannelCollectionPage)((ChannelCollectionRequest)client.teams(group.id).channels().buildRequest(new Option[0])).get()).getCurrentPage();
        }
        catch (ClientException e) {
            Logger.error((Throwable)e);
            List<Channel> list2 = Collections.emptyList();
            if (list2 == null) {
                TeamsInfo.$$$reportNull$$$0(1);
            }
            return list2;
        }
        if (list == null) {
            TeamsInfo.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    private GraphServiceClient<Request> client() {
        GraphServiceClient graphServiceClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)this.getAuth()).buildClient();
        if (graphServiceClient == null) {
            TeamsInfo.$$$reportNull$$$0(2);
        }
        return graphServiceClient;
    }

    private TokenCredentialAuthProvider getAuth() {
        return new TokenCredentialAuthProvider((TokenCredential)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(this.credentials.getChannelAuthTenant())).clientId(this.credentials.getAppId())).clientSecret(this.credentials.getAppPassword()).build());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "io/intino/amidas/connectors/microsoft/teams/TeamsInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "channels";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "client";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

