/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.connectors.microsoft.teams;

import com.microsoft.bot.builder.Bot;
import com.microsoft.bot.connector.authentication.MicrosoftAppCredentials;
import com.microsoft.bot.integration.AdapterWithErrorHandler;
import com.microsoft.bot.integration.BotFrameworkHttpAdapter;
import com.microsoft.bot.integration.Configuration;
import io.intino.alexandria.http.AlexandriaSpark;
import io.intino.alexandria.logger.Logger;
import io.intino.amidas.connectors.microsoft.teams.BotController;
import io.intino.amidas.connectors.microsoft.teams.ProxyBot;
import io.intino.amidas.connectors.microsoft.teams.TeamsConfiguration;
import io.intino.amidas.connectors.microsoft.teams.TeamsInfo;
import io.intino.amidas.connectors.microsoft.teams.model.Team;
import io.intino.amidas.shared.connectors.MessagingConnector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class TeamsConnector
implements MessagingConnector {
    private final TeamsConfiguration configuration;
    private BotController botController;
    private ProxyBot bot;
    private MicrosoftAppCredentials credentials;
    private List<Team> teams;

    public TeamsConnector(String appUrl, String appCliPath, File storeDir, File credentialsFile) {
        this.configuration = new TeamsConfiguration(appUrl, appCliPath, storeDir, credentialsFile);
    }

    public void setup(AlexandriaSpark spark) {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(this.configuration.credentialsFile()));
            AdapterWithErrorHandler adapter = new AdapterWithErrorHandler(TeamsConnector.configuration(properties));
            this.credentials = TeamsConnector.credentials(properties);
            this.bot = new ProxyBot(this.credentials, this.configuration, (BotFrameworkHttpAdapter)adapter);
            this.botController = new BotController(spark, (BotFrameworkHttpAdapter)adapter, (Bot)this.bot);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public void start(io.intino.amidas.shared.Team team) {
        this.scheduleReloadTeams();
        this.botController.start();
    }

    public boolean sendMessage(String team, String channel, String message) {
        if (message.isEmpty()) {
            Logger.error((String)"Notification empty");
            return false;
        }
        Logger.info((String)("Trying to notify " + message + " to " + team + " -> " + channel));
        try {
            return this.bot.sendMessage(this.channelId(team, channel), message);
        }
        catch (IllegalArgumentException e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    private String channelId(String team, String channel) {
        if (team == null) {
            throw new IllegalArgumentException("Team not found");
        }
        return this.teams.stream().filter((Predicate<Team>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$channelId$0(java.lang.String io.intino.amidas.connectors.microsoft.teams.model.Team ), (Lio/intino/amidas/connectors/microsoft/teams/model/Team;)Z)((String)team)).findFirst().orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$channelId$1(java.lang.String ), ()Ljava/lang/IllegalArgumentException;)((String)team)).channels.stream().filter((Predicate<Team.Channel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$channelId$2(java.lang.String io.intino.amidas.connectors.microsoft.teams.model.Team$Channel ), (Lio/intino/amidas/connectors/microsoft/teams/model/Team$Channel;)Z)((String)channel)).findFirst().orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$channelId$3(java.lang.String ), ()Ljava/lang/IllegalArgumentException;)((String)channel)).id;
    }

    private static Configuration configuration(final Properties properties) {
        return new Configuration(){

            public String getProperty(String s) {
                return properties.getProperty(s);
            }

            public Properties getProperties() {
                return properties;
            }

            public String[] getProperties(String s) {
                return properties.stringPropertyNames().toArray(new String[0]);
            }
        };
    }

    private static MicrosoftAppCredentials credentials(Properties properties) {
        return new MicrosoftAppCredentials(properties.getProperty("MicrosoftAppId"), properties.getProperty("MicrosoftAppPassword"), properties.getProperty("MicrosoftAppTenant"));
    }

    private void scheduleReloadTeams() {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(() -> {
            List<Team> newTeams = new TeamsInfo(this.credentials).reloadTeams();
            this.teams.clear();
            this.teams.addAll(newTeams);
        }, 0L, 1L, TimeUnit.HOURS);
        this.teams = new TeamsInfo(this.credentials).reloadTeams();
    }

    private static /* synthetic */ IllegalArgumentException lambda$channelId$3(String channel) {
        return new IllegalArgumentException("Channel " + channel + " not found");
    }

    private static /* synthetic */ boolean lambda$channelId$2(String channel, Team.Channel c) {
        return c.displayName.equals(channel);
    }

    private static /* synthetic */ IllegalArgumentException lambda$channelId$1(String team) {
        return new IllegalArgumentException("Team " + team + " not found");
    }

    private static /* synthetic */ boolean lambda$channelId$0(String team, Team tm) {
        return tm.displayName.equals(team);
    }
}

