/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.connectors.microsoft.azure;

import io.intino.alexandria.http.AlexandriaSpark;
import io.intino.alexandria.logger.Logger;
import io.intino.amidas.connectors.microsoft.azure.ActiveDirectoryAccessor;
import io.intino.amidas.connectors.microsoft.azure.model.User;
import io.intino.amidas.shared.Team;
import io.intino.amidas.shared.connectors.ActiveDirectoryConnector;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class AzureConnector
implements ActiveDirectoryConnector {
    private ActiveDirectoryAccessor activeDirectory;
    private final File credentialsFile;
    private Team team;
    private static final AtomicBoolean Enabled = new AtomicBoolean(false);

    public AzureConnector(File credentialsFile) {
        this.credentialsFile = credentialsFile;
    }

    public void setup(AlexandriaSpark alexandriaSpark) {
    }

    public void start(Team team) {
        if (!this.credentialsFile.exists()) {
            Logger.error((String)"Active Directory credentials file not found");
            return;
        }
        this.team = team;
        this.activeDirectory = new ActiveDirectoryAccessor(this.credentialsFile);
        Enabled.set(true);
        this.refresh();
    }

    public void refresh() {
        if (!Enabled.get()) {
            return;
        }
        this.activeDirectory.refresh();
        List identityList = this.team.search("");
        Map<String, Team.Identity> identityMap = identityList.stream().collect(Collectors.toMap(i -> i.getId("username").value(), i -> i, (i1, i2) -> i1));
        try {
            this.activeDirectory.users().stream().filter(user -> !identityMap.containsKey(user.id)).forEach(this::createIdentity);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    private void createIdentity(User user) {
        try {
            Team.Identity identity = this.team.createIdentity();
            identity.append("id/username", user.id);
            identity.append("id/email", user.mail);
            identity.append("feature/fullname", user.displayName);
            identity.append("feature/language", user.language != null ? user.language : "en");
            identity.save();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public ActiveDirectoryConnector.Frequency refreshFrequency() {
        return ActiveDirectoryConnector.Frequency.Hourly;
    }
}

