/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.connectors.microsoft.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.graph.requests.UserCollectionRequestBuilder;
import io.intino.amidas.connectors.microsoft.azure.CredentialReader;
import io.intino.amidas.connectors.microsoft.azure.model.User;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ActiveDirectoryAccessor {
    private final List<User> users = Collections.synchronizedList(new ArrayList());
    private final CredentialReader credentialReader;

    public ActiveDirectoryAccessor(File credentialsFile) {
        this.credentialReader = new CredentialReader(credentialsFile);
    }

    public List<User> users() {
        return this.users;
    }

    public User user(String id) {
        return this.users.stream().filter(f -> id.equals(f.id)).findFirst().orElse(null);
    }

    public void refresh() {
        GraphServiceClient graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)this.getAuth()).buildClient();
        UserCollectionRequestBuilder request = graphClient.users();
        UserCollectionPage page = (UserCollectionPage)((UserCollectionRequest)request.buildRequest(new Option[0])).get();
        ArrayList<User> users = new ArrayList<User>();
        if (page != null) {
            users.addAll(this.map(page.getCurrentPage()));
        }
        while (page != null && (request = (UserCollectionRequestBuilder)page.getNextPage()) != null) {
            page = (UserCollectionPage)((UserCollectionRequest)request.buildRequest(new Option[0])).get();
            if (page == null) continue;
            users.addAll(this.map(page.getCurrentPage()));
        }
        this.users.clear();
        this.users.addAll(users);
    }

    private List<User> map(List<com.microsoft.graph.models.User> users) {
        return users.stream().map((? super T u) -> new User(u.id, u.displayName, u.givenName, u.mail, u.preferredLanguage)).collect(Collectors.toList());
    }

    @NotNull
    private TokenCredentialAuthProvider getAuth() {
        return new TokenCredentialAuthProvider((TokenCredential)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(this.credentialReader.tenantId())).clientId(this.credentialReader.clientId())).clientSecret(this.credentialReader.secret()).build());
    }
}

