package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.identityeditor.box.commands.identity.IdentityCommands;

public class TeamTemplate extends AbstractTeamTemplate<IdentityEditorBox> {

    public TeamTemplate(IdentityEditorBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        loadingPage.visible(true);
        teamEditorPage.teamEditorStamp.team(box().team());
        teamEditorPage.teamEditorStamp.identityManagerRoles(box().identitiesManagerRoles());
        teamEditorPage.teamEditorStamp.onModifyIdentity((identity, statements) -> box().commands(IdentityCommands.class).saveIdentity(identity, statements, username()));
        teamEditorPage.teamEditorStamp.filter("");
        teamEditorPage.teamEditorStamp.refresh();
        loadingPage.visible(false);
        teamEditorPage.visible(true);
    }

    public void reloadTeam() {
        teamEditorPage.teamEditorStamp.reloadTeam(box().team());
	}
}