package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.amidas.identityeditor.box.ui.displays.DisplayHelper;
import io.intino.amidas.identityeditor.box.ui.displays.notifiers.PropertyViewerNotifier;

public class PropertyViewer extends io.intino.amidas.identityeditor.box.ui.displays.templates.AbstractPropertyViewer<PropertyViewerNotifier, Box> {
    private io.intino.alexandria.zif.grammar.Property _property;
    private String _value;

    public PropertyViewer(Box box) {
        super(box);
    }

    public PropertyViewer property(io.intino.alexandria.zif.grammar.Property property) {
        this._property = property;
        return this;
    }

    public PropertyViewer value(String value) {
        this._value = value;
        return this;
    }

    @Override
    public void refresh() {
        super.refresh();
        property.value(_property.label());
        refreshStringValue();
        refreshImageValue();
    }

    private void refreshStringValue() {
        stringType.visible(_property.type() == io.intino.alexandria.zif.grammar.Property.Type.string);
        stringValue.value(isValid(_value) ? _value : "-");
    }

    private void refreshImageValue() {
        boolean isImage = _property.type() == io.intino.alexandria.zif.grammar.Property.Type.image;
        imageType.visible(isImage);
        if (!isImage) return;
        refreshImage(_value);
    }

    private void refreshImage(String value) {
        if (!isValid(value)) return;
        imageValue.value(DisplayHelper.toUrl(_property, value, username()));
    }

    private boolean isValid(String value) {
        return value != null && !value.isEmpty();
    }

}