package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.zif.grammar.Property;
import io.intino.amidas.identityeditor.box.ui.displays.notifiers.ProfileEditorNotifier;
import io.intino.amidas.shared.Team;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class ProfileEditor extends AbstractProfileEditor<ProfileEditorNotifier, Box> {
	private Team.Identity identity;
	private List<Property> properties;
	private BiConsumer<Team.Identity, List<Team.Statement>> identityModifiedListener;

	public ProfileEditor(Box box) {
		super(box);
	}

	public ProfileEditor identity(Team.Identity identity, List<Property> properties) {
		this.identity = identity;
		this.properties = properties;
		return this;
	}

	public ProfileEditor onModifyIdentity(BiConsumer<Team.Identity, List<Team.Statement>> listener) {
		this.identityModifiedListener = listener;
		return this;
	}

	@Override
	public void init() {
		super.init();
		initDialog();
	}

	private void initDialog() {
		openEditIdentity.onOpen(e -> {
			identityDialogBox.main.dialog.properties(properties);
			identityDialogBox.main.dialog.identity(identity);
			identityDialogBox.main.dialog.refresh();
		});
		cancel.onExecute(e -> identityDialogBox.close());
		accept.onExecute(e -> saveProfile());
	}

	private void saveProfile() {
		identityDialogBox.close();
		notifyUser(translate("Profile saved"), UserMessage.Type.Success);
		notifySave(identityDialogBox.main.dialog.identity(), identityDialogBox.main.dialog.statements());
		refreshIdentity();
	}

	private void notifySave(Team.Identity identity, List<Team.Statement> statements) {
		if (identityModifiedListener != null) identityModifiedListener.accept(identity, statements);
	}

	@Override
	public void refresh() {
		super.refresh();
		refreshLayers();
		if (identity == null) return;
		refreshIdentity();
	}

	private void refreshLayers() {
		profileNotFoundLayer.visible(identity == null);
		profileEditorLayer.visible(identity != null);
	}

	private void refreshIdentity() {
		identityViewer.identity(identity, properties);
		identityViewer.refresh();
	}

}