package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.zif.Grammar;
import io.intino.alexandria.zif.grammar.Property;
import io.intino.amidas.identityeditor.box.ui.displays.notifiers.IdentityViewerNotifier;
import io.intino.amidas.shared.Team;

import java.util.List;

import static java.util.stream.Collectors.toList;

public class IdentityViewer extends io.intino.amidas.identityeditor.box.ui.displays.templates.AbstractIdentityViewer<IdentityViewerNotifier, Box> {
    private Team.Identity identity;
    private List<Property> _properties;

    public IdentityViewer(Box box) {
        super(box);
    }

    public IdentityViewer identity(Team.Identity identity, List<Property> properties) {
        this.identity = identity;
        this._properties = properties;
        return this;
    }

    @Override
    public void init() {
        super.init();
        featuresTitle.value(translate("Features"));
        credentialsTitle.value(translate("Credentials"));
        rolesTitle.value(translate("Roles"));
    }

    @Override
    public void refresh() {
        super.refresh();
        showLoading();
        emptyLayer.emptyText.value(translate("No identities found"));
        refreshIdentity();
        hideLoading();
    }

    private void refreshIdentity() {
        if (identity == null) return;
        refreshFeatures();
        refreshCredentials();
        refreshRoles();
    }

    private void showLoading() {
        loadingLayer.visible(true);
        emptyLayer.visible(false);
        mainLayer.visible(false);
    }

    private void hideLoading() {
        loadingLayer.visible(false);
        emptyLayer.visible(identity == null);
        mainLayer.visible(identity != null);
    }

    private void refreshFeatures() {
        featuresPanel.visible(false);
        featuresPanel.featuresStamp.clear();
        _properties.stream().filter(Property::isIdentifier).map(this::definitionOf).toList().forEach(f -> fill(f, featuresPanel.featuresStamp.add()));
        _properties.stream().filter(Property::isFeature).map(this::definitionOf).toList().forEach(f -> fill(f, featuresPanel.featuresStamp.add()));
        featuresPanel.visible(true);
    }

    private void refreshCredentials() {
        credentialsPanel.visible(false);
        credentialsPanel.credentialsStamp.clear();
        _properties.stream().filter(Property::isCredential).map(this::definitionOf).toList().forEach(f -> fill(f, credentialsPanel.credentialsStamp.add()));
        credentialsPanel.visible(_properties.stream().anyMatch(Property::isCredential));
    }

    private void refreshRoles() {
        rolesPanel.visible(false);
        rolesPanel.rolesStamp.clear();
        _properties.stream().filter(Property::isRole).map(this::definitionOf).toList().forEach(f -> fill(f, rolesPanel.rolesStamp.add()));
        rolesPanel.visible(_properties.stream().anyMatch(Property::isRole));
    }

    private void fill(Team.Definition definition, PropertyViewer viewer) {
        viewer.property(propertyOf(definition.property()));
        viewer.value(definition.value());
        viewer.refresh();
    }

    private Team.Definition definitionOf(Property property) {
        return new Team.Definition() {
            @Override
            public String property() {
                return property.name();
            }

            @Override
            public String value() {
                Team.Statement statement = identity.get(property.name());
                return statement != null ? statement.value() : "";
            }
        };
    }

    private Property propertyOf(String name) {
        return _properties.stream().filter(p -> p.name().equals(name)).findFirst().orElse(null);
    }

}