package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.zif.grammar.Property;
import io.intino.amidas.identityeditor.box.ui.displays.notifiers.IdentityEditorNotifier;
import io.intino.amidas.shared.Team;
import io.intino.amidas.shared.Team.Identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class IdentityEditor extends AbstractIdentityEditor<IdentityEditorNotifier, Box> {
	private Identity identity;
	private List<Property> properties;
	private Map<String, Team.Statement> statements = new HashMap<>();
	private BiFunction<Property, String, Boolean> propertyChecker;

	public IdentityEditor(Box box) {
        super(box);
    }

	public IdentityEditor identity(Identity identity) {
		this.identity = identity;
		this.statements = new HashMap<>();
		return this;
	}

	public List<Team.Statement> statements() {
		return new ArrayList<>(this.statements.values());
	}

	public IdentityEditor properties(List<Property> properties) {
		this.properties = properties;
		return this;
	}

	public IdentityEditor propertyChecker(BiFunction<Property, String, Boolean> propertyChecker) {
		this.propertyChecker = propertyChecker;
		return this;
	}

	@Override
	public void refresh() {
		super.refresh();
		showLoading();
		refreshIdentity();
		hideLoading();
	}

	private void showLoading() {
		loadingLayer.visible(true);
		mainLayer.visible(false);
	}

	private void hideLoading() {
		loadingLayer.visible(false);
		mainLayer.visible(identity != null);
	}

	private void refreshIdentity() {
		propertiesStamp.clear();
		properties.forEach(p -> fill(definitionOf(p.name()), propertiesStamp.add()));
	}

	private void fill(Team.Definition definition, PropertyEditor editor) {
		editor.property(propertyOf(definition.property()));
		editor.propertyChecker(propertyChecker);
		editor.value(definition.value());
		editor.onChange(value -> saveStatement(definition, value));
		editor.refresh();
	}

	private Team.Definition definitionOf(String property) {
		Team.Statement statement = identity.get(property);
		String value = statement != null ? statement.value() : "";
		return definitionOf(property, value);
	}

	private Team.Definition definitionOf(String property, String value) {
		return new Team.Definition() {
			@Override
			public String property() {
				return property;
			}

			@Override
			public String value() {
				return value;
			}
		};
	}

	private void saveStatement(Team.Definition definition, String value) {
		if (definition.property().startsWith("role/") && (value == null || value.isEmpty())) value = "from 99999999";
		identity.append(definitionOf(definition.property(), value));
		statements.put(definition.property(), statementOf(definition.property(), value));
	}

	private Team.Statement statementOf(String property, String value) {
		return new Team.Statement(property, value);
	}

	private Property propertyOf(String name) {
		return properties.stream().filter(p -> p.name().equals(name)).findFirst().orElse(null);
	}
}