package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.zif.grammar.Property;
import io.intino.amidas.identityeditor.box.ui.displays.notifiers.IdentityDialogNotifier;
import io.intino.amidas.shared.Team;
import io.intino.amidas.shared.Team.Identity;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class IdentityDialog extends AbstractIdentityDialog<IdentityDialogNotifier, Box> {
    private Identity identity;
    private List<Property> properties;
    private BiFunction<Property, String, Boolean> propertyChecker;

    public IdentityDialog(Box box) {
        super(box);
    }

    public IdentityDialog identity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public List<Team.Statement> statements() {
        return identityEditor.statements();
    }

    public IdentityDialog properties(List<Property> properties) {
        this.properties = properties;
        return this;
    }

    public IdentityDialog propertyChecker(BiFunction<Property, String, Boolean> checker) {
        this.propertyChecker = checker;
        return this;
    }

    @Override
    public void refresh() {
        super.refresh();
        identityEditor.properties(properties);
        identityEditor.identity(identity);
        identityEditor.propertyChecker(propertyChecker);
        identityEditor.refresh();
    }

}