package io.intino.amidas.identityeditor.box.ui.displays;

import io.intino.alexandria.Base64;
import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zif.grammar.Property;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class DisplayHelper {

	public static URL toUrl(Property property, String base64, String username) {
		try {
			Path temporalPath = Files.createTempFile(username + "_" + property.name().replace("/", "_"), ".bin");
			Files.write(temporalPath, Base64.decode(base64), StandardOpenOption.WRITE);
			return temporalPath.toUri().toURL();
		} catch (IOException e) {
			Logger.error(e);
			return null;
		}
	}

	public static String toString(Resource file) {
		try {
			return Base64.encode(file.bytes());
		} catch (IOException e) {
			Logger.error(e);
			return null;
		}
	}

}
