package io.intino.amidas.identityeditor.box.ui;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.services.push.User;
import io.intino.alexandria.zif.grammar.Property;
import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.shared.Team;
import io.intino.amidas.shared.Team.Identity;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class TeamHelper {

	public static boolean isRootIdentityManager(IdentityEditorBox box, User user) {
		return isRootIdentityManager(box.team(), box.identitiesManagerRoles(), user);
	}

	public static boolean isRootIdentityManager(Team team, List<String> identitiesManagerRoles, User user) {
		if (team == null) return true;
		if (user == null) return true;
		return identitiesManagerRoles.size() > 0 && isIdentityManager(team, user, identitiesManagerRoles.get(0));
	}

	public static boolean isIdentityManager(IdentityEditorBox box, User user) {
		if (box.team() == null) return true;
		if (user == null) return true;
		List<String> roles = box.identitiesManagerRoles();
		return roles.stream().anyMatch(r -> isIdentityManager(box, user, r));
	}

	private static boolean isIdentityManager(IdentityEditorBox box, User user, String role) {
		return isIdentityManager(box.team(), user, role);
	}

	private static boolean isIdentityManager(Team team, User user, String role) {
		List<Identity> result = team.search("role/" + role, "");
		return result.stream().filter(i -> isIdentityOfUserLogged(i, user)).anyMatch(i -> isIdentityRoleEnabled(i, role));
	}

	private static List<String> identityRoles(IdentityEditorBox box, User user) {
		return box.identitiesManagerRoles().stream().filter(r -> isIdentityManager(box, user, r)).collect(Collectors.toList());
	}

	private static List<String> identityRoles(Team team, List<String> identityManagerRoles, User user) {
		return identityManagerRoles.stream().filter(r -> isIdentityManager(team, user, r)).collect(Collectors.toList());
	}

	public static boolean isRolePropertyManager(IdentityEditorBox box, User user, Property property) {
		return isRolePropertyManager(box.team(), box.identitiesManagerRoles(), user, property);
	}

	public static boolean isRolePropertyManager(Team team, List<String> identityManagerRoles, User user, Property property) {
		if (!property.name().startsWith("role/")) return true;
		List<String> identityRoles = identityRoles(team, identityManagerRoles, user);
		return identityRoles.stream().anyMatch(r -> groupOf(r).isEmpty() || groupOf(r).equals(groupOf(property.name())));
	}

	private static String groupOf(String role) {
		role = role.replace("role/", "");
		if (!role.contains("/")) return "";
		return role.substring(0, role.indexOf("/"));
	}

	private static boolean isIdentityOfUserLogged(Identity identity, User user) {
		try {
			if (user == null) return false;
			String username = user.username();
			return identity.ids().stream().anyMatch(id -> id.value().equals(username));
		}
		catch (Exception ex) {
			Logger.error(ex);
			return false;
		}
	}

	private static boolean isIdentityRoleEnabled(Identity identity, String role) {
		Team.Role identityRole = identity.getRole(role);
		if (identityRole == null) return false;
		return identityRole.isEnabled(Instant.now());
	}

}
