package io.intino.amidas.identityeditor.box.ui;
import io.intino.amidas.identityeditor.box.ui.displays.*;
import io.intino.amidas.identityeditor.box.ui.displays.notifiers.*;
import io.intino.amidas.identityeditor.box.ui.displays.requesters.*;
import io.intino.amidas.identityeditor.box.ui.resources.*;
import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.identityeditor.box.IdentityEditorConfiguration;

import io.intino.alexandria.ui.UISpark;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifier;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import io.intino.alexandria.ui.resources.AssetResourceLoader;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.alexandria.ui.spark.resources.AfterDisplayRequest;
import io.intino.alexandria.ui.spark.resources.AssetResource;
import io.intino.alexandria.ui.spark.resources.AuthenticateCallbackResource;
import io.intino.alexandria.ui.spark.resources.BeforeDisplayRequest;

import java.net.MalformedURLException;
import java.net.URL;

public class IdentityEditorElementsService extends io.intino.alexandria.ui.UI {

	public static void init(UISpark spark, IdentityEditorBox box, PushService pushService, DisplayRouteDispatcher routeDispatcher) {
		IdentityEditorConfiguration configuration = (IdentityEditorConfiguration) box.configuration();
		box.routeManager(routeManager(spark, routeDispatcher));
		spark.route("/push").push(pushService);
		spark.route("/authenticate-callback").get(manager -> new AuthenticateCallbackResource(manager, notifierProvider()).execute());
		spark.route("/authenticate-callback/").get(manager -> new AuthenticateCallbackResource(manager, notifierProvider()).execute());
		spark.route("/asset/:name").get(manager -> new AssetResource(name -> new AssetResourceLoader(box).load(name), manager, notifierProvider()).execute());
		spark.route("/alexandria/user").get(manager -> new HomeResource(box, manager, notifierProvider()).execute());
		spark.route("/").get(manager -> new HomeResource(box, manager, notifierProvider()).execute());
		spark.route("/team").get(manager -> new TeamResource(box, manager, notifierProvider()).execute());
		spark.route("/profile").get(manager -> new ProfileResource(box, manager, notifierProvider()).execute());
		spark.route("/error").get(manager -> new ErrorResource(box, manager, notifierProvider()).execute());
		spark.route("/identityviewerproxy/:displayId/personify").post(manager -> new IdentityViewerProxyResource(box, manager, notifierProvider()).execute());
		spark.route("/identitydialogproxy/:displayId/personify").post(manager -> new IdentityDialogProxyResource(box, manager, notifierProvider()).execute());
		spark.route("/identityeditorproxy/:displayId/personify").post(manager -> new IdentityEditorProxyResource(box, manager, notifierProvider()).execute());
		spark.route("/propertyviewerproxy/:displayId/personify").post(manager -> new PropertyViewerProxyResource(box, manager, notifierProvider()).execute());
		spark.route("/propertyeditorproxy/:displayId/personify").post(manager -> new PropertyEditorProxyResource(box, manager, notifierProvider()).execute());
		spark.route("/profileeditorproxy/:displayId/personify").post(manager -> new ProfileEditorProxyResource(box, manager, notifierProvider()).execute());
		spark.route("/teameditorproxy/:displayId/personify").post(manager -> new TeamEditorProxyResource(box, manager, notifierProvider()).execute());
		initDisplays(spark, pushService);
	}

	public static void initDisplays(UISpark spark, PushService pushService) {
		initIdentityViewer(spark, pushService);
		initIdentityDialog(spark, pushService);
		initIdentityEditor(spark, pushService);
		initPropertyViewer(spark, pushService);
		initPropertyEditor(spark, pushService);
		initProfileEditor(spark, pushService);
		initTeamEditor(spark, pushService);
		initTeamTemplate(spark, pushService);
		initProfileTemplate(spark, pushService);
		initErrorTemplate(spark, pushService);
		initHeader(spark, pushService);
		initFooter(spark, pushService);
		registerNotifiers();
	}

	private static void registerNotifiers() {
		register(IdentityViewerNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.IdentityViewer.class);
		register(IdentityViewerProxyNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.IdentityViewerProxy.class);
		register(IdentityDialogNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.IdentityDialog.class);
		register(IdentityDialogProxyNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.IdentityDialogProxy.class);
		register(IdentityEditorNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.IdentityEditor.class);
		register(IdentityEditorProxyNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.IdentityEditorProxy.class);
		register(PropertyViewerNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.PropertyViewer.class);
		register(PropertyViewerProxyNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.PropertyViewerProxy.class);
		register(PropertyEditorNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.PropertyEditor.class);
		register(PropertyEditorProxyNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.PropertyEditorProxy.class);
		register(ProfileEditorNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.ProfileEditor.class);
		register(ProfileEditorProxyNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.ProfileEditorProxy.class);
		register(TeamEditorNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.TeamEditor.class);
		register(TeamEditorProxyNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.TeamEditorProxy.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.TeamTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.ProfileTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.ErrorTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.Header.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.amidas.identityeditor.box.ui.displays.templates.Footer.class);
	}

	private static void initIdentityViewer(UISpark spark, PushService pushService) {
		spark.route("/identityviewer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/identityviewer/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/identityviewer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("identityviewer", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());
		spark.route("/identityviewerproxy/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/identityviewerproxy/:displayId").post(manager -> new IdentityViewerProxyRequester(manager, notifierProvider()).execute());
		spark.route("/identityviewerproxy/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
	}
	private static void initIdentityDialog(UISpark spark, PushService pushService) {
		spark.route("/identitydialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/identitydialog/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/identitydialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("identitydialog", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());
		spark.route("/identitydialogproxy/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/identitydialogproxy/:displayId").post(manager -> new IdentityDialogProxyRequester(manager, notifierProvider()).execute());
		spark.route("/identitydialogproxy/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
	}
	private static void initIdentityEditor(UISpark spark, PushService pushService) {
		spark.route("/identityeditor/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/identityeditor/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/identityeditor/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("identityeditor", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());
		spark.route("/identityeditorproxy/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/identityeditorproxy/:displayId").post(manager -> new IdentityEditorProxyRequester(manager, notifierProvider()).execute());
		spark.route("/identityeditorproxy/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
	}
	private static void initPropertyViewer(UISpark spark, PushService pushService) {
		spark.route("/propertyviewer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/propertyviewer/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/propertyviewer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("propertyviewer", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());
		spark.route("/propertyviewerproxy/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/propertyviewerproxy/:displayId").post(manager -> new PropertyViewerProxyRequester(manager, notifierProvider()).execute());
		spark.route("/propertyviewerproxy/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
	}
	private static void initPropertyEditor(UISpark spark, PushService pushService) {
		spark.route("/propertyeditor/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/propertyeditor/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/propertyeditor/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("propertyeditor", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());
		spark.route("/propertyeditorproxy/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/propertyeditorproxy/:displayId").post(manager -> new PropertyEditorProxyRequester(manager, notifierProvider()).execute());
		spark.route("/propertyeditorproxy/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
	}
	private static void initProfileEditor(UISpark spark, PushService pushService) {
		spark.route("/profileeditor/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/profileeditor/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/profileeditor/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("profileeditor", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());
		spark.route("/profileeditorproxy/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/profileeditorproxy/:displayId").post(manager -> new ProfileEditorProxyRequester(manager, notifierProvider()).execute());
		spark.route("/profileeditorproxy/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
	}
	private static void initTeamEditor(UISpark spark, PushService pushService) {
		spark.route("/teameditor/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/teameditor/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/teameditor/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("teameditor", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());
		spark.route("/teameditorproxy/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/teameditorproxy/:displayId").post(manager -> new TeamEditorProxyRequester(manager, notifierProvider()).execute());
		spark.route("/teameditorproxy/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
	}
	private static void initTeamTemplate(UISpark spark, PushService pushService) {
		spark.route("/teamtemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/teamtemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/teamtemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("teamtemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initProfileTemplate(UISpark spark, PushService pushService) {
		spark.route("/profiletemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/profiletemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/profiletemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("profiletemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initErrorTemplate(UISpark spark, PushService pushService) {
		spark.route("/errortemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/errortemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/errortemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("errortemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initHeader(UISpark spark, PushService pushService) {
		spark.route("/header/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/header/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/header/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("header", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initFooter(UISpark spark, PushService pushService) {
		spark.route("/footer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/footer/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/footer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("footer", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
}