package io.intino.amidas.identityeditor.box.commands.identity;

import io.intino.alexandria.logger.Logger;
import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.identityeditor.box.commands.Command;
import io.intino.amidas.shared.Team;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;

public class SaveIdentityCommand extends Command<Team.Identity> {
	public Team.Identity identity;
	public List<Team.Statement> statements;

	public SaveIdentityCommand(IdentityEditorBox box) {
		super(box);
	}

	@Override
	public Team.Identity execute() {
		saveIdentities();
		notifyIdentityChanged(identity);
		return identity;
	}

	private void saveIdentities() {
		Path temporalFile = null;
		try {
			temporalFile = Files.createTempFile(identifiesFilename() + "_", ".zif");
			Path path = box.configuration().identitiesFile().toPath();
			Files.copy(path, temporalFile, StandardCopyOption.REPLACE_EXISTING);
			Team team = new Team(temporalFile.toFile());
			Team.Builder builder = team.build(identity);
			statements.forEach(builder::append);
			builder.save();
		} catch (IOException e) {
			Logger.error(e);
		}
		finally {
			if (temporalFile != null) temporalFile.toFile().delete();
		}
	}

	private String identifiesFilename() {
		File current = box.configuration().identitiesFile();
		return current.getName().substring(0, current.getName().lastIndexOf("."));
	}

}