package io.intino.amidas.identityeditor.box.commands;

import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.shared.Team;

import java.time.Instant;

public abstract class Command<T> {
	public final IdentityEditorBox box;
	public String author;
	public Instant ts;

	public Command(IdentityEditorBox box) {
		this.box = box;
	}

	public abstract T execute();

	protected void notifyIdentityChanged(Team.Identity identity) {
		box.notifyIdentityChanged(identity, author);
	}
}