package io.intino.amidas.identityeditor.box;

import java.util.Map;
import java.util.HashMap;
import java.io.File;

public class IdentityEditorConfiguration extends io.intino.alexandria.core.BoxConfiguration {

	public IdentityEditorConfiguration(String[] args) {
		super(args);
	}

	public String port() {
		return get("port");
	}

	public String federationUrl() {
		return get("federation_url");
	}

	public String url() {
		return get("url");
	}

	public String title() {
		return get("title");
	}

	public String subtitle() {
		return get("subtitle");
	}

	public String logo() {
		return get("logo");
	}

	public String background() {
		return get("background");
	}

	public File identitiesFile() {
		return get("identities_file") == null ? null : new File(get("identities_file"));
	}

	public String identitiesManagerRoles() {
		return get("identities_manager_roles");
	}

	public String workspace() {
		return get("workspace");
	}

	public String datahubUrl() {
		return get("datahub_url");
	}

	public String datahubClientid() {
		return get("datahub_clientId");
	}

	public String datahubUser() {
		return get("datahub_user");
	}

	public String datahubPassword() {
		return get("datahub_password");
	}

	public File datahubOutboxDirectory() {
		return get("datahub_outbox_directory") == null ? null : new File(get("datahub_outbox_directory"));
	}

	public String datalakePath() {
		return get("datalake_path");
	}

	public java.io.File home() {
		return new java.io.File(args.getOrDefault("home", System.getProperty("user.home")));
	}
}