package io.intino.amidas.identityeditor.box;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.auth.Space;
import io.intino.amidas.accessor.alexandria.core.AmidasOauthAccessor;
import io.intino.amidas.identityeditor.box.commands.Commands;
import io.intino.amidas.identityeditor.box.commands.CommandsFactory;
import io.intino.amidas.shared.Identity;
import io.intino.amidas.shared.IdentityChangeEvent;
import io.intino.amidas.shared.Team;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public class IdentityEditorBox extends AbstractBox {
	private CommandsFactory commandsFactory;
	private Team team;
	private Consumer<IdentityChangeEvent> identityChangeListener;

	public IdentityEditorBox(String[] args) {
		super(args);
	}

	public IdentityEditorBox(IdentityEditorConfiguration configuration) {
		super(configuration);
	}

	@Override
	public io.intino.alexandria.core.Box put(Object o) {
		super.put(o);
		return this;
	}

	public <F extends Commands> F commands(Class<F> clazz) {
		return commandsFactory.command(clazz);
	}

	public void onIdentityChange(Consumer<IdentityChangeEvent> listener) {
		identityChangeListener = listener;
	}

	@Override
	public void beforeStart() {
		this.commandsFactory = new CommandsFactory(this);
		this.team = createTeam();
	}

	public Team team() {
		return team;
	}

	@Override
	public void afterStart() {

	}

	public io.intino.alexandria.core.Box start() {
		return super.start();
	}

	@Override
	public void beforeStop() {

	}

	@Override
	public void afterStop() {
	}

	public File identitiesFile() {
		return configuration().identitiesFile();
	}

	@Override
	protected AuthService authService(URL authServiceUrl) {
		try {
			if (authServiceUrl == null) return null;
			return new AmidasOauthAccessor(new Space(new URL(configuration().url())), authServiceUrl);
		} catch (MalformedURLException e) {
			Logger.error(e);
			return null;
		}
	}

	public void reloadTeam() {
		this.team = createTeam();
	}

	private Team createTeam() {
		try {
			File file = identitiesFile();
			return file.exists() ? new Team(file) : null;
		} catch (IOException e) {
			Logger.error(e);
			return null;
		}
	}

	public List<String> identitiesManagerRoles() {
		return Arrays.asList(configuration.identitiesManagerRoles().split(","));
	}

	public void notifyIdentityChanged(Identity identity, String author) {
		if (identityChangeListener == null) return;
		identityChangeListener.accept(new IdentityChangeEvent(identity, author));
	}
}