package io.intino.amidas.identityeditor.box;

import io.intino.alexandria.ui.services.translator.Dictionary;

import java.util.HashMap;
import java.util.Map;
import java.util.ArrayList;
import java.util.List;

public class I18n {
	private static Map<String, Dictionary> dictionaries = new HashMap<>();

	public static String translate(String word, String language) {
		language = dictionaries.containsKey(language) ? language : "en";
		Dictionary dictionary = dictionaries.get(language);
		return dictionary != null && dictionary.containsKey(word) ? dictionary.get(word) : word;
	}

	public static List<Dictionary> dictionaries() {
		return new ArrayList<>(dictionaries.values());
	}

	static {
		dictionaries.put("mx", new Dictionary() {{
			put("Previous identity", "Identidad anterior");
			put("Next identity", "Identidad siguiente");
			put("Add identity", "Añadir identidad");
			put("Remove identity", "Borrar identidad");
			put("Edit identity", "Editar identidad");
			put("Search identity...", "Buscar identidad...");
			put("No identities found", "No se han encontrado identidades");
			put("Are you sure you want to remove identity?", "¿Está seguro que desea borrar la identidad?");
			put("Features", "Características");
			put("Credentials", "Credenciales");
			put("Roles", "Roles");
			put("No identities", "No hay identidades");
			put("1 identity", "1 identidad");
			put(" identities", " identidades");
			put("for", "para");
			put("Cancel", "Cancelar");
			put("OK", "Aceptar");
			put("Accept", "Aceptar");
			put("Identity saved", "Se ha guardado la identidad correctamente");
			put("Identities file not found. Check your configuration.", "No se ha encontrado el fichero de identidades. Por favor, compruebe su configuración.");
			put("options: ", "opciones: ");
			put("format: ", "formato: ");
			put("Affirm", "Afirmación");
			put("You don't have access permissions", "No tiene permisos para acceder");
			put("Logout", "Cerrar sesión");
			put("Already in use", "Ya está en uso");
		}}.language("mx"));
	}
}