package io.intino.amidas.datahub;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.Scale;
import io.intino.alexandria.event.Event;
import io.intino.amidas.datahub.events.*;
import java.util.List;

public class IdentityEditorTerminal {
	private static final Scale scale = Scale.Month;
	private final io.intino.alexandria.event.EventHub eventHub;
	private java.util.Map<java.util.function.Consumer<?>, java.util.function.Consumer<io.intino.alexandria.event.Event>> consumers = new java.util.HashMap<>();

	public static String[] subscriptionChannels = new String[]{};

	public IdentityEditorTerminal(io.intino.alexandria.event.EventHub eventHub) {
		this.eventHub = eventHub;
	}

	public void publish(Object event, String context) {
		if (event instanceof io.intino.amidas.datahub.events.Identities) publish((io.intino.amidas.datahub.events.Identities) event);
		if (event instanceof io.intino.amidas.datahub.events.LoginSession) publish((io.intino.amidas.datahub.events.LoginSession) event);
		if (event instanceof io.intino.amidas.datahub.events.LogoutSession) publish((io.intino.amidas.datahub.events.LogoutSession) event);
	}

	public BatchSession batch(java.io.File dataHubStageDirectory, java.io.File temporalStageDirectory) {
		return new BatchSession(dataHubStageDirectory, temporalStageDirectory);
	}

	public void publish(io.intino.alexandria.event.SessionEvent session) {
		eventHub.sendEvent(io.intino.alexandria.event.SessionEvent.PATH, session);
	}

	public void subscribe(SessionEventConsumer onEventReceived) {
		consumers.put(onEventReceived, event -> onEventReceived.accept(new io.intino.alexandria.event.SessionEvent(event.toMessage())));
		eventHub.attachListener(io.intino.alexandria.event.SessionEvent.PATH, consumers.get(onEventReceived));
	}

	public void publish(io.intino.amidas.datahub.events.Identities identities) {
		eventHub.sendEvent("federation.Identities", identities);
	}

	public void publish(io.intino.amidas.datahub.events.LoginSession loginSession) {
		eventHub.sendEvent("LoginSession", loginSession);
	}

	public void publish(io.intino.amidas.datahub.events.LogoutSession logoutSession) {
		eventHub.sendEvent("LogoutSession", logoutSession);
	}

	public void subscribe(IdentitiesConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, event -> onEventReceived.accept(new io.intino.amidas.datahub.events.Identities(event)));
		eventHub.attachListener("federation.Identities", subscriberId, consumers.get(onEventReceived));
	}

	public void subscribe(IdentitiesConsumer onEventReceived) {
		consumers.put(onEventReceived, event -> onEventReceived.accept(new io.intino.amidas.datahub.events.Identities(event)));
		eventHub.attachListener("federation.Identities", consumers.get(onEventReceived));
	}

	public void unsubscribe(IdentitiesConsumer onEventReceived) {
		eventHub.detachListeners(consumers.get(onEventReceived));
	}

	public void subscribe(LoginSessionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, event -> onEventReceived.accept(new io.intino.amidas.datahub.events.LoginSession(event)));
		eventHub.attachListener("LoginSession", subscriberId, consumers.get(onEventReceived));
	}

	public void subscribe(LoginSessionConsumer onEventReceived) {
		consumers.put(onEventReceived, event -> onEventReceived.accept(new io.intino.amidas.datahub.events.LoginSession(event)));
		eventHub.attachListener("LoginSession", consumers.get(onEventReceived));
	}

	public void unsubscribe(LoginSessionConsumer onEventReceived) {
		eventHub.detachListeners(consumers.get(onEventReceived));
	}

	public void subscribe(LogoutSessionConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, event -> onEventReceived.accept(new io.intino.amidas.datahub.events.LogoutSession(event)));
		eventHub.attachListener("LogoutSession", subscriberId, consumers.get(onEventReceived));
	}

	public void subscribe(LogoutSessionConsumer onEventReceived) {
		consumers.put(onEventReceived, event -> onEventReceived.accept(new io.intino.amidas.datahub.events.LogoutSession(event)));
		eventHub.attachListener("LogoutSession", consumers.get(onEventReceived));
	}

	public void unsubscribe(LogoutSessionConsumer onEventReceived) {
		eventHub.detachListeners(consumers.get(onEventReceived));
	}

	public void start() {
		if (eventHub instanceof io.intino.alexandria.event.JmsEventHub) ((io.intino.alexandria.event.JmsEventHub) eventHub).start();
	}

	public void stop() {
		if (eventHub instanceof io.intino.alexandria.event.JmsEventHub) ((io.intino.alexandria.event.JmsEventHub) eventHub).stop();
	}

	private static final Object monitor = new Object();

	public class BatchSession {
		private final java.io.File dataHubStage;
		private final java.io.File temporalStage;
		private final io.intino.alexandria.ingestion.SessionHandler sessionHandler;
		private final io.intino.alexandria.ingestion.EventSession eventSession;


		public BatchSession(java.io.File dataHubStage, java.io.File temporalStage) {
			this.dataHubStage = dataHubStage;
			this.temporalStage = temporalStage;
			this.sessionHandler = new io.intino.alexandria.ingestion.SessionHandler(temporalStage);
			this.eventSession = sessionHandler.createEventSession();
		}

		public void feed(Event event, String context) {
            eventSession.put(tankOf(event, context), Timetag.of(event.ts(), scale), event);
		}

		public void push() {
			eventSession.close();
			sessionHandler.pushTo(this.dataHubStage);
			//eventHub.sendEvent("service.ness.push", new Event(new io.intino.alexandria.message.Message("Push").set("stage", temporalStage.getName())));
		}

		public synchronized void seal() {
			synchronized(monitor) {
				eventHub.requestResponse("service.ness.seal", new Event(new io.intino.alexandria.message.Message("Seal").set("stage", temporalStage.getName())).ts(java.time.Instant.now()).toString(), s -> {
						synchronized(monitor) {
							monitor.notify();
						}
					}
				);
				try {
					monitor.wait();
				} catch (InterruptedException e) {
					io.intino.alexandria.logger.Logger.error(e);
				}
			}
        }

        private String tankOf(Event event, String context) {
        	if (event instanceof io.intino.amidas.datahub.events.Identities) return "federation.Identities";
        	if (event instanceof io.intino.amidas.datahub.events.LoginSession) return "LoginSession";
        	if (event instanceof io.intino.amidas.datahub.events.LogoutSession) return "LogoutSession";
        	return event.toMessage().type();
        }
	}

	public interface SessionEventConsumer extends java.util.function.Consumer<io.intino.alexandria.event.SessionEvent> {
	}

	public interface LoginSessionConsumer extends java.util.function.Consumer<io.intino.amidas.datahub.events.LoginSession> {
	}

	public interface LogoutSessionConsumer extends java.util.function.Consumer<io.intino.amidas.datahub.events.LogoutSession> {
	}

	public interface IdentitiesConsumer extends java.util.function.Consumer<io.intino.amidas.datahub.events.Identities> {
	}
}