/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.datahub;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.EventHub;
import io.intino.alexandria.ingestion.EventSession;
import io.intino.alexandria.ingestion.SessionHandler;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.amidas.datahub.events.Identities;
import io.intino.amidas.datahub.events.LoginSession;
import io.intino.amidas.datahub.events.LogoutSession;
import java.io.File;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class FederationTerminal {
    private static final Scale scale = Scale.Month;
    private final EventHub eventHub;
    private Map<Consumer<?>, Consumer<Event>> consumers = new HashMap();
    public static String[] subscriptionChannels = new String[0];
    private static final Object monitor = new Object();

    public FederationTerminal(EventHub eventHub) {
        this.eventHub = eventHub;
    }

    public void publish(Object event, String context) {
        if (event instanceof Identities) {
            this.publish((Identities)event);
        }
        if (event instanceof LoginSession) {
            this.publish((LoginSession)event);
        }
        if (event instanceof LogoutSession) {
            this.publish((LogoutSession)event);
        }
    }

    public BatchSession batch(File dataHubStageDirectory, File temporalStageDirectory) {
        return new BatchSession(dataHubStageDirectory, temporalStageDirectory);
    }

    public void publish(Identities identities) {
        this.eventHub.sendEvent("federation.Identities", (Event)identities);
    }

    public void publish(LoginSession loginSession) {
        this.eventHub.sendEvent("LoginSession", (Event)loginSession);
    }

    public void publish(LogoutSession logoutSession) {
        this.eventHub.sendEvent("LogoutSession", (Event)logoutSession);
    }

    public void subscribe(IdentitiesConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new Identities(event)));
        this.eventHub.attachListener("federation.Identities", subscriberId, this.consumers.get(onEventReceived));
    }

    public void subscribe(IdentitiesConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new Identities(event)));
        this.eventHub.attachListener("federation.Identities", this.consumers.get(onEventReceived));
    }

    public void unsubscribe(IdentitiesConsumer onEventReceived) {
        this.eventHub.detachListeners(this.consumers.get(onEventReceived));
    }

    public void subscribe(LoginSessionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new LoginSession(event)));
        this.eventHub.attachListener("LoginSession", subscriberId, this.consumers.get(onEventReceived));
    }

    public void subscribe(LoginSessionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new LoginSession(event)));
        this.eventHub.attachListener("LoginSession", this.consumers.get(onEventReceived));
    }

    public void unsubscribe(LoginSessionConsumer onEventReceived) {
        this.eventHub.detachListeners(this.consumers.get(onEventReceived));
    }

    public void subscribe(LogoutSessionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new LogoutSession(event)));
        this.eventHub.attachListener("LogoutSession", subscriberId, this.consumers.get(onEventReceived));
    }

    public void subscribe(LogoutSessionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new LogoutSession(event)));
        this.eventHub.attachListener("LogoutSession", this.consumers.get(onEventReceived));
    }

    public void unsubscribe(LogoutSessionConsumer onEventReceived) {
        this.eventHub.detachListeners(this.consumers.get(onEventReceived));
    }

    public void stop() {
    }

    public static interface LoginSessionConsumer
    extends Consumer<LoginSession> {
    }

    public static interface LogoutSessionConsumer
    extends Consumer<LogoutSession> {
    }

    public static interface IdentitiesConsumer
    extends Consumer<Identities> {
    }

    public class BatchSession {
        private final File dataHubStage;
        private final File temporalStage;
        private final SessionHandler sessionHandler;
        private final EventSession eventSession;

        public BatchSession(File dataHubStage, File temporalStage) {
            this.dataHubStage = dataHubStage;
            this.temporalStage = temporalStage;
            this.sessionHandler = new SessionHandler(temporalStage);
            this.eventSession = this.sessionHandler.createEventSession();
        }

        public void feed(Event event, String context) {
            this.eventSession.put(this.tankOf(event, context), Timetag.of((Instant)event.ts(), (Scale)scale), new Event[]{event});
        }

        public void push() {
            this.sessionHandler.pushTo(this.dataHubStage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void seal() {
            Object object = monitor;
            synchronized (object) {
                FederationTerminal.this.eventHub.requestResponse("service.ness.seal", new Event(new Message("Seal").set("stage", this.temporalStage.getName())).ts(Instant.now()).toString(), s -> monitor.notify());
                try {
                    monitor.wait();
                }
                catch (InterruptedException e) {
                    Logger.error((Throwable)e);
                }
            }
        }

        private String tankOf(Event event, String context) {
            if (event instanceof Identities) {
                return "federation.Identities";
            }
            if (event instanceof LoginSession) {
                return "LoginSession";
            }
            if (event instanceof LogoutSession) {
                return "LogoutSession";
            }
            return event.toMessage().type();
        }
    }
}

