/*
 * Decompiled with CFR 0.152.
 */
package amidas.proxy.core;

import amidas.proxy.AmidasApi;
import amidas.proxy.AmidasSetupApi;
import amidas.proxy.adapters.request.DeviceRequestAdapter;
import amidas.proxy.adapters.request.WorkRequestAdapter;
import amidas.proxy.adapters.response.AmidasInfoResponseAdapter;
import amidas.proxy.adapters.response.DeviceResponseAdapter;
import amidas.proxy.adapters.response.UserInfoResponseAdapter;
import amidas.proxy.core.Amidas;
import amidas.proxy.core.AmidasInfo;
import amidas.proxy.core.Device;
import amidas.proxy.core.PushClient;
import amidas.proxy.core.Space;
import amidas.proxy.core.Token;
import amidas.proxy.core.UserInfo;
import amidas.proxy.core.Verifier;
import amidas.proxy.core.Work;
import amidas.proxy.core.exceptions.AmidasApiFailure;
import amidas.proxy.core.exceptions.CouldNotObtainAccessToken;
import amidas.proxy.core.exceptions.CouldNotObtainAuthorizationUrl;
import amidas.proxy.core.exceptions.CouldNotObtainRequestToken;
import amidas.proxy.core.exceptions.SpaceAuthenticateCallbackUrlIsNull;
import amidas.proxy.core.works.EditionWork;
import amidas.proxy.core.works.RequestWork;
import amidas.proxy.core.works.SignatureWork;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import cotton.restful.RestfulClient;
import cotton.restful.core.exceptions.RestfulFailure;
import cotton.restful.setups.java.RestfulClient;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.Api;
import org.scribe.builder.api.DefaultApi10a;
import org.scribe.oauth.OAuthService;

public class AmidasProxy
implements AmidasApi,
AmidasSetupApi {
    private Map<Amidas, PushClient> pushClientMap = new HashMap<Amidas, PushClient>();
    private cotton.restful.RestfulClient client = new RestfulClient();
    private static final String ResponseOk = "OK";

    @Override
    public AmidasApi.Authenticating authenticate(final Amidas amidas) {
        return space -> new AmidasApi.Authenticating.Authentication(){
            private OAuthService authService;
            private Token requestToken;
            private Token accessToken;
            {
                this.authService = AmidasProxy.this.serviceOf(amidas, space);
            }

            @Override
            public Token requestToken() throws CouldNotObtainRequestToken {
                try {
                    this.requestToken = AmidasProxy.this.tokenFrom(Optional.of(this.authService.getRequestToken()));
                }
                catch (Exception exception) {
                    throw new CouldNotObtainRequestToken();
                }
                this.accessToken = null;
                return this.requestToken;
            }

            @Override
            public URL authenticationUrl(Token requestToken) throws CouldNotObtainAuthorizationUrl {
                if (this.requestToken != requestToken) {
                    return null;
                }
                try {
                    return new URL(this.authService.getAuthorizationUrl(AmidasProxy.this.token(Optional.of(requestToken))));
                }
                catch (Exception e) {
                    throw new CouldNotObtainAuthorizationUrl();
                }
            }

            @Override
            public Token accessToken() {
                return this.accessToken;
            }

            @Override
            public Token accessToken(Verifier verifier) throws CouldNotObtainAccessToken {
                if (this.requestToken == null) {
                    return null;
                }
                try {
                    org.scribe.model.Token accessToken = this.authService.getAccessToken(AmidasProxy.this.token(Optional.of(this.requestToken)), AmidasProxy.this.verifier(verifier));
                    this.accessToken = AmidasProxy.this.tokenFrom(Optional.of(accessToken));
                }
                catch (Exception exception) {
                    throw new CouldNotObtainAccessToken();
                }
                return this.accessToken;
            }

            @Override
            public void invalidate() throws AmidasApiFailure {
                try {
                    AmidasProxy.this.client.post(amidas.url(), String.format("/api/invalidate/%s", this.accessToken.id()));
                }
                catch (Exception e) {
                    throw new AmidasApiFailure(String.format("Could not invalidate token %s", this.accessToken.id()));
                }
            }
        };
    }

    @Override
    public boolean valid(Amidas amidas, Token accessToken) throws AmidasApiFailure {
        try {
            return this.getAndCheck(amidas.url(), String.format("/api/valid/%s", accessToken.id()));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public AmidasInfo info(Amidas amidas, Token accessToken) throws AmidasApiFailure {
        try {
            RestfulClient.Response response = this.client.get(amidas.url(), String.format("/api/info/%s", accessToken.id()));
            return (AmidasInfo)new AmidasInfoResponseAdapter().adapt(response.content());
        }
        catch (Exception exception) {
            throw new AmidasApiFailure(String.format("Could not receive amidas info with token %s", accessToken.id()));
        }
    }

    @Override
    public UserInfo me(Amidas amidas, Token accessToken) throws AmidasApiFailure {
        try {
            RestfulClient.Response response = this.client.get(amidas.url(), String.format("/api/me/%s", accessToken.id()));
            return (UserInfo)new UserInfoResponseAdapter().adapt(response.content());
        }
        catch (RestfulFailure failure) {
            throw new AmidasApiFailure(String.format("Could not receive user info with token %s", accessToken.id()));
        }
    }

    @Override
    public void logout(Amidas amidas, Token accessToken) throws AmidasApiFailure {
        try {
            this.client.post(amidas.url(), String.format("/api/logout/%s", accessToken.id()));
        }
        catch (Exception e) {
            throw new AmidasApiFailure(String.format("Could not logout with token %s", accessToken.id()));
        }
    }

    @Override
    public void addPushListener(Amidas amidas, Token accessToken, AmidasApi.AmidasPushListener listener) throws AmidasApiFailure {
        if (!this.pushClientMap.containsKey(amidas)) {
            AmidasInfo info = this.info(amidas, accessToken);
            this.pushClientMap.put(amidas, this.createPushClient(info));
        }
        PushClient pushClient = this.pushClientMap.get(amidas);
        pushClient.addListener(listener);
    }

    @Override
    public boolean validate(Amidas amidas, final String signature, final String hash) throws AmidasApiFailure {
        try {
            RestfulClient.Response response = this.client.post(amidas.url(), "/signature", (Map)new HashMap<String, String>(){
                {
                    this.put("operation", "validate");
                    this.put("signature", signature);
                    this.put("hash", hash);
                }
            });
            return response.content().equals(ResponseOk);
        }
        catch (Exception e) {
            throw new AmidasApiFailure("Could not validate signature");
        }
    }

    @Override
    public AmidasSetupApi.Connection connect(Amidas amidas) {
        return this.connect(amidas, null, null);
    }

    @Override
    public AmidasSetupApi.Connection connect(final Amidas amidas, final URL certificate, final String password) {
        return new AmidasSetupApi.Connection(){
            private RestfulClient.RestfulSecureConnection connection = null;

            @Override
            public boolean ping() {
                try {
                    RestfulClient.Response response = this.secure().get("/ping");
                    return response.content().equals(AmidasProxy.ResponseOk);
                }
                catch (Exception e) {
                    return false;
                }
            }

            @Override
            public AmidasInfo info() throws AmidasApiFailure {
                try {
                    RestfulClient.Response response = this.secure().get("/info");
                    return (AmidasInfo)new AmidasInfoResponseAdapter().adapt(response.content());
                }
                catch (Exception e) {
                    throw new AmidasApiFailure("Could not load amidas info");
                }
            }

            @Override
            public UserInfo user(final String username, final String email) throws AmidasApiFailure {
                try {
                    RestfulClient.Response response = this.secure().get("/user", (Map)new HashMap<String, String>(){
                        {
                            this.put("operation", "info");
                            this.put("username", username);
                            this.put("email", email);
                        }
                    });
                    return (UserInfo)new UserInfoResponseAdapter().adapt(response.content());
                }
                catch (Exception e) {
                    throw new AmidasApiFailure(String.format("Could not load user info of %s with email %s", username, email));
                }
            }

            @Override
            public UserInfo user(final Token token) throws AmidasApiFailure {
                try {
                    RestfulClient.Response response = this.secure().get("/user", (Map)new HashMap<String, String>(){
                        {
                            this.put("operation", "infoFromToken");
                            this.put("token", token.id());
                        }
                    });
                    return (UserInfo)new UserInfoResponseAdapter().adapt(response.content());
                }
                catch (Exception e) {
                    throw new AmidasApiFailure(String.format("Could not load user info from token %s", token));
                }
            }

            @Override
            public List<Device> devices() throws AmidasApiFailure {
                try {
                    RestfulClient.Response response = this.secure().get("/devices", Collections.singletonMap("operation", "info"));
                    return new DeviceResponseAdapter().adaptList(response.content());
                }
                catch (Exception e) {
                    throw new AmidasApiFailure("Could not load devices");
                }
            }

            @Override
            public List<Device> devices(final String username) throws AmidasApiFailure {
                try {
                    RestfulClient.Response response = this.secure().get("/devices", (Map)new HashMap<String, String>(){
                        {
                            this.put("operation", "info");
                            this.put("username", username);
                        }
                    });
                    return new DeviceResponseAdapter().adaptList(response.content());
                }
                catch (Exception e) {
                    throw new AmidasApiFailure(String.format("Could not load user %s devices", username));
                }
            }

            @Override
            public boolean register(final Device device) throws AmidasApiFailure {
                try {
                    RestfulClient.Response response = this.secure().post(String.format("/device/%s", device.id()), (Map)new HashMap<String, String>(){
                        {
                            this.put("device", new DeviceRequestAdapter().adapt(device).toString());
                        }
                    });
                    return response.content().equals(AmidasProxy.ResponseOk);
                }
                catch (Exception e) {
                    throw new AmidasApiFailure(String.format("Could not register device %s", device.id()));
                }
            }

            @Override
            public boolean unRegister(final Device device) throws AmidasApiFailure {
                try {
                    RestfulClient.Response response = this.secure().delete(String.format("/device/%s", device.id()), (Map)new HashMap<String, String>(){
                        {
                            this.put("device", new DeviceRequestAdapter().adapt(device).toString());
                        }
                    });
                    return response.content().equals(AmidasProxy.ResponseOk);
                }
                catch (Exception e) {
                    throw new AmidasApiFailure(String.format("Could not register federation %s", device.id()));
                }
            }

            @Override
            public String register(EditionWork work) throws AmidasApiFailure {
                return this.registerWork(work);
            }

            @Override
            public String register(RequestWork work) throws AmidasApiFailure {
                return this.registerWork(work);
            }

            @Override
            public String register(SignatureWork work) throws AmidasApiFailure {
                return this.registerWork(work);
            }

            @Override
            public boolean cancel(Work work, final String responsible) throws AmidasApiFailure {
                try {
                    RestfulClient.Response response = this.secure().put(String.format("/work/%s", work.name()), (Map)new HashMap<String, String>(){
                        {
                            this.put("operation", "cancel");
                            this.put("responsible", responsible);
                        }
                    });
                    return response.content().equals(AmidasProxy.ResponseOk);
                }
                catch (Exception e) {
                    throw new AmidasApiFailure(String.format("Could not cancel work %s", work.name()));
                }
            }

            private String registerWork(final Work work) throws AmidasApiFailure {
                try {
                    RestfulClient.Response response = this.secure().post("/work", (Map)new HashMap<String, String>(){
                        {
                            this.put("work", new WorkRequestAdapter().adapt(work).toString());
                        }
                    });
                    return response.content();
                }
                catch (Exception e) {
                    throw new AmidasApiFailure(String.format("Could not register work %s", work.label()));
                }
            }

            private RestfulClient.RestfulSecureConnection secure() {
                if (this.connection == null) {
                    this.connection = AmidasProxy.this.client.secureConnection(amidas.url(), certificate, password);
                }
                return this.connection;
            }
        };
    }

    private PushClient createPushClient(AmidasInfo info) {
        return new AmidasPushClient(info);
    }

    private Token tokenFrom(Optional<org.scribe.model.Token> token) {
        if (!token.isPresent()) {
            return null;
        }
        return () -> ((org.scribe.model.Token)token.get()).getToken();
    }

    private org.scribe.model.Token token(Optional<Token> token) {
        if (!token.isPresent()) {
            return null;
        }
        return new org.scribe.model.Token(token.get().id(), "");
    }

    private org.scribe.model.Verifier verifier(Verifier verifier) {
        return new org.scribe.model.Verifier(verifier.value());
    }

    private OAuthService serviceOf(Amidas amidas, Space space) throws SpaceAuthenticateCallbackUrlIsNull {
        ServiceBuilder builder = new ServiceBuilder().provider(this.apiOf(amidas)).apiKey(space.name()).apiSecret(space.secret());
        URL callbackUrl = space.authenticateCallbackUrl();
        if (callbackUrl == null) {
            throw new SpaceAuthenticateCallbackUrlIsNull();
        }
        builder.callback(callbackUrl.toString());
        return builder.build();
    }

    private Api apiOf(Amidas amidas) {
        String AuthenticationPath = "/authentication/%s";
        String RequestTokenPath = "/authentication/token/request";
        String AccessTokenPath = "/authentication/token/access";
        final String url = amidas.url().toString();
        return new DefaultApi10a(){

            public String getRequestTokenEndpoint() {
                return url + "/authentication/token/request";
            }

            public String getAccessTokenEndpoint() {
                return url + "/authentication/token/access";
            }

            public String getAuthorizationUrl(org.scribe.model.Token token) {
                return url + String.format("/authentication/%s", token.getToken());
            }
        };
    }

    private boolean getAndCheck(URL url, String resource) throws RestfulFailure {
        return Boolean.valueOf(this.client.get(url, resource).content());
    }

    private static class AmidasPushClient
    implements PushClient {
        private final AmidasInfo info;
        private WebSocketClient client;
        private List<AmidasApi.AmidasPushListener> listenerList;

        public AmidasPushClient(AmidasInfo info) {
            this.info = info;
            this.listenerList = new ArrayList<AmidasApi.AmidasPushListener>();
            this.createClient();
        }

        private void createClient() {
            this.client = new WebSocketClient(this.info.pushServerUri()){

                public void onOpen(ServerHandshake serverHandshake) {
                }

                public void onMessage(String message) {
                    this.notify(message);
                }

                public void onClose(int i, String s, boolean b) {
                }

                public void onError(Exception e) {
                }
            };
            this.client.connect();
        }

        @Override
        public void notify(String rawMessage) {
            Message message = this.messageOf(rawMessage);
            if (!rawMessage.contains("userLoggedOut") && !rawMessage.contains("userAdded")) {
                return;
            }
            for (AmidasApi.AmidasPushListener listener : this.listenerList) {
                if (message.name.equals("userLoggedOut")) {
                    listener.userLoggedOut((UserInfo)new UserInfoResponseAdapter().adapt(message.param("userInfo")));
                }
                if (!message.name.equals("userAdded")) continue;
                listener.userAdded((UserInfo)new UserInfoResponseAdapter().adapt(message.param("userInfo")));
            }
        }

        private Message messageOf(String rawMessage) {
            return Message.build(rawMessage);
        }

        @Override
        public void addListener(AmidasApi.AmidasPushListener listener) {
            this.listenerList.add(listener);
        }

        private static class Message {
            private String name;
            private JsonObject rawParameters;

            public Message(String name) {
                this.name = name;
            }

            public String name() {
                return this.name;
            }

            public JsonElement param(String name) {
                if (this.rawParameters == null) {
                    return null;
                }
                return this.rawParameters.get(name);
            }

            public static Message build(String rawData) {
                JsonElement raw = new JsonParser().parse(rawData);
                if (raw instanceof JsonPrimitive) {
                    return new Message(raw.getAsString());
                }
                JsonObject rawMessage = (JsonObject)raw;
                Message message = new Message(rawMessage.get("name").getAsString());
                message.rawParameters = rawMessage.get("parameters").getAsJsonObject();
                return message;
            }
        }
    }
}

