/*
 * Decompiled with CFR 0.152.
 */
package amidas.proxy.adapters.request;

import amidas.proxy.adapters.request.RequestAdapter;
import amidas.proxy.core.Facet;
import amidas.proxy.core.Work;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class WorkRequestAdapter
implements RequestAdapter<Work> {
    @Override
    public JsonObject adapt(Work work) {
        JsonObject result = new JsonObject();
        result.addProperty("label", work.label());
        result.addProperty("description", work.description());
        result.addProperty("thread", work.thread());
        result.addProperty("originator", work.originator());
        result.addProperty("priority", work.priority().toString());
        result.add("facets", (JsonElement)this.facetsOf(work));
        result.add("traces", (JsonElement)this.tracesOf(work));
        result.add("tags", (JsonElement)this.tagsOf(work));
        return result;
    }

    private JsonArray facetsOf(Work work) {
        JsonArray result = new JsonArray();
        work.facets().forEach(facet -> result.add((JsonElement)this.facetOf((Facet)facet)));
        return result;
    }

    private JsonObject facetOf(Facet facet) {
        JsonObject result = new JsonObject();
        result.addProperty("name", facet.name());
        facet.parameters().forEach((name, value) -> result.add(name, (JsonElement)this.toJsonArray((List<String>)value)));
        return result;
    }

    private JsonArray tracesOf(Work work) {
        JsonArray result = new JsonArray();
        work.traces().forEach(trace -> result.add((JsonElement)this.traceOf((Work.Trace)trace)));
        return result;
    }

    private JsonObject traceOf(Work.Trace trace) {
        return this.toJsonObject(trace.createDate(), trace.description(), trace.attachments());
    }

    private JsonArray tagsOf(Work work) {
        return this.toJsonArray(work.tags());
    }

    private JsonObject toJsonObject(LocalDateTime createDate, String description, Map<String, InputStream> attachments) {
        JsonObject result = new JsonObject();
        result.addProperty("createDate", (Number)this.millisecondsOf(createDate));
        result.addProperty("description", description);
        result.add("attachments", (JsonElement)this.toJsonArray(new ArrayList<String>(attachments.keySet())));
        return result;
    }

    private JsonArray toJsonArray(List<String> values) {
        JsonArray result = new JsonArray();
        values.forEach(value -> result.add((JsonElement)new JsonPrimitive(value)));
        return result;
    }

    private long millisecondsOf(LocalDateTime dateTime) {
        if (dateTime == null) {
            return -1L;
        }
        return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant()).getTime();
    }
}

