/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.accessor.alexandria.core;

import com.google.gson.Gson;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.auth.FederationInfo;
import io.intino.alexandria.ui.services.auth.Space;
import io.intino.alexandria.ui.services.auth.Token;
import io.intino.alexandria.ui.services.auth.UserInfo;
import io.intino.alexandria.ui.services.auth.Verifier;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainAuthorizationUrl;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class AmidasCasAccessor
implements AuthService {
    private URL authServiceUrl;
    private Space space;
    private Map<String, UserInfo> userInfoMap = new HashMap<String, UserInfo>();
    private static final String AuthorizationPath = "/login?service=%s";

    public AmidasCasAccessor(Space space, URL authServiceUrl) {
        this.space = space;
        this.authServiceUrl = authServiceUrl;
    }

    public URL url() {
        return this.authServiceUrl;
    }

    public Space space() {
        return this.space;
    }

    public AuthService.Authentication authenticate() {
        return new AuthService.Authentication(){
            private Token requestToken;
            private Token accessToken;

            public Token requestToken() {
                this.requestToken = new Token(){

                    public String id() {
                        return UUID.randomUUID().toString();
                    }

                    public String secret() {
                        return "";
                    }
                };
                this.accessToken = null;
                return this.requestToken;
            }

            public URL authenticationUrl(Token token) throws CouldNotObtainAuthorizationUrl {
                if (this.requestToken != token) {
                    return null;
                }
                return AmidasCasAccessor.this.authorizationUrl(this.requestToken.id());
            }

            public Token accessToken() {
                return this.accessToken;
            }

            public Token accessToken(final Verifier verifier) {
                this.accessToken = verifier != null && this.accessToken == null ? new Token(){

                    public String id() {
                        return verifier.value();
                    }

                    public String secret() {
                        return "1234";
                    }
                } : null;
                return this.accessToken;
            }

            public void invalidate() {
                AmidasCasAccessor.this.logout(this.accessToken);
            }

            public AuthService.Authentication.Version version() {
                return AuthService.Authentication.Version.OAuth2;
            }
        };
    }

    public boolean valid(Token token) {
        try {
            if (token == null || token.id() == null) {
                return false;
            }
            return this.me(token) != null;
        }
        catch (CouldNotObtainInfo ignored) {
            return false;
        }
    }

    public FederationInfo info(Token token) throws CouldNotObtainInfo {
        return new FederationInfo(){

            public String name() {
                return "CAS";
            }

            public String title() {
                return "CAS federation";
            }

            public String subtitle() {
                return null;
            }

            public URL logo() {
                return null;
            }

            public URI pushServerUri() {
                return null;
            }
        };
    }

    public UserInfo me(Token token) throws CouldNotObtainInfo {
        String tokenId = token.id();
        if (tokenId == null) {
            return null;
        }
        if (this.userInfoMap.get(tokenId) != null) {
            return this.userInfoMap.get(tokenId);
        }
        HttpGet get = new HttpGet(String.valueOf(this.url()) + "/serviceValidate?ticket=" + tokenId + "&service=" + this.callbackUrl(this.space) + "&format=JSON");
        try {
            String line;
            CloseableHttpClient client = HttpClientFactory.client();
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new CouldNotObtainInfo(new Exception("Status!=200"));
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuilder result = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            Map map = (Map)new Gson().fromJson(result.toString(), Map.class);
            if (!map.containsKey("serviceResponse")) {
                return null;
            }
            Map serviceResponse = (Map)map.get("serviceResponse");
            if (!serviceResponse.containsKey("authenticationSuccess")) {
                return null;
            }
            this.userInfoMap.put(tokenId, this.userInfo((Map)serviceResponse.get("authenticationSuccess")));
            return this.userInfoMap.get(tokenId);
        }
        catch (IOException e) {
            throw new CouldNotObtainInfo((Exception)e);
        }
    }

    public void logout(Token token) {
        if (token == null || token.id() == null) {
            return;
        }
        this.userInfoMap.remove(token.id());
    }

    public String logoutUrl() {
        return String.valueOf(this.url()) + "/logout";
    }

    public void addPushListener(Token token, AuthService.FederationNotificationListener federationNotificationListener) throws CouldNotObtainInfo {
    }

    private Space createSpace(URL spaceUrl) {
        if (spaceUrl == null) {
            return null;
        }
        Space space = new Space(this.url());
        space.setBaseUrl(spaceUrl.toString());
        return space;
    }

    private URL urlOf(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private URL authorizationUrl(String authId) {
        return this.urlOf(String.valueOf(this.authServiceUrl) + String.format(AuthorizationPath, this.callbackUrl(this.space)));
    }

    private String callbackUrl(Space space) {
        return AmidasCasAccessor.encode(this.space().url().toString() + "/authenticate-callback");
    }

    public static String encode(String value) {
        if (value == null) {
            return null;
        }
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    private UserInfo userInfo(final Map<String, Object> map) {
        return new UserInfo(){

            public String username() {
                return map.get("user").toString();
            }

            public String fullName() {
                return map.get("user").toString();
            }

            public URL photo() {
                return null;
            }

            public String email() {
                return "";
            }

            public String language() {
                return "es";
            }

            public List<String> roleList() {
                return Collections.emptyList();
            }
        };
    }

    public static class HttpClientFactory {
        public static CloseableHttpClient client() throws IOException {
            try {
                SSLContextBuilder builder = new SSLContextBuilder();
                builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                Registry registry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
                cm.setMaxTotal(100);
                return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).setConnectionManager((HttpClientConnectionManager)cm).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new IOException("Error getting client");
            }
        }
    }
}

