/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.accessor.alexandria.adapters.response;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.intino.alexandria.ui.services.auth.UserInfo;
import io.intino.amidas.accessor.adapters.response.ObjectResponseAdapter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class UserInfoResponseAdapter
extends ObjectResponseAdapter<UserInfo> {
    @Override
    protected UserInfo adapt(final JsonObject element) {
        return new UserInfo(){

            public String username() {
                return element.get("name").getAsString();
            }

            public String fullName() {
                return element.get("title").getAsString();
            }

            public URL photo() {
                try {
                    return new URL(element.get("image").getAsString());
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }

            public String email() {
                return element.get("email").getAsString();
            }

            public String language() {
                return element.get("language").getAsString();
            }

            public List<String> roleList() {
                JsonArray roleList = element.getAsJsonArray("roleList");
                ArrayList<String> result = new ArrayList<String>();
                if (roleList == null) {
                    return result;
                }
                roleList.forEach(a -> result.add(a.getAsString()));
                return result;
            }
        };
    }
}

