package io.intino.amidas.accessor.core.exceptions;

import io.intino.amidas.accessor.core.Error;

import java.util.HashMap;
import java.util.Map;

public class AmidasNotFound extends Exception implements Error {
    private String url;

    public AmidasNotFound(String url) {
        this.url = url;
    }

    @Override
    public String code() {
        return "err:anfe";
    }

    @Override
    public String label() {
        return "Could not connect to amidas. Check amidas is running at " + url;
    }

    @Override
    public Map<String, String> parameters() {
        return new HashMap<>();
    }
}
