/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.accessor.alexandria.core;

import com.google.gson.Gson;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.restaccessor.Response;
import io.intino.alexandria.restaccessor.RestAccessor;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.auth.FederationInfo;
import io.intino.alexandria.ui.services.auth.Space;
import io.intino.alexandria.ui.services.auth.UserInfo;
import io.intino.alexandria.ui.services.auth.Verifier;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotInvalidateAccessToken;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainAccessToken;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainAuthorizationUrl;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainInfo;
import io.intino.alexandria.ui.services.auth.exceptions.SpaceAuthCallbackUrlIsNull;
import io.intino.amidas.accessor.core.Configuration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.Api;
import org.scribe.builder.api.DefaultApi20;
import org.scribe.model.OAuthConfig;
import org.scribe.model.Token;
import org.scribe.oauth.OAuthService;

public class AmidasAzureAccessor
implements AuthService {
    private final Space space;
    private final Configuration configuration;
    private UserInfo userInfo;
    private final RestAccessor api;
    private static final String GraphUrl = "graphUrl";
    private static final String TenantId = "tenantId";
    private static final String ClientId = "clientId";
    private static final String ClientSecret = "clientSecret";
    private static final String Scope = "00000003-0000-0000-c000-000000000000%2F.default";
    private static final String CodeVerifier = "YTFjNjI1OWYzMzA3MTI4ZDY2Njg5M2RkNmVjNDE5YmEyZGRhOGYyM2IzNjdmZWFhMTQ1ODg3NDcxY2Nl";
    private static final String AuthorizationUrl = "/%s/oauth2/v2.0/authorize?client_id=%s&response_type=code&redirect_uri=%s&response_mode=query&scope=%s&state=1234&code_challenge=%s";
    private static final String TokenPath = "/%s/oauth2/v2.0/token";
    private static final String LogoutPath = "/%s/oauth2/logout?client_id=%s&post_logout_redirect_uri=%s";
    private static final String RevokePath = "/%s/oauth2/v2.0/token/revoke?token=%s";

    public AmidasAzureAccessor(Space space, Configuration configuration) {
        this.space = space;
        this.configuration = configuration;
        this.api = new io.intino.alexandria.restaccessor.core.RestAccessor();
    }

    public URL url() {
        return this.configuration.url();
    }

    public Space space() {
        return this.space;
    }

    public AuthService.Authentication authenticate() throws SpaceAuthCallbackUrlIsNull {
        return new AuthService.Authentication(){
            private final OAuthService authService;
            private io.intino.alexandria.ui.services.auth.Token requestToken;
            private io.intino.alexandria.ui.services.auth.Token accessToken;
            {
                this.authService = AmidasAzureAccessor.this.authService();
            }

            public io.intino.alexandria.ui.services.auth.Token requestToken() {
                this.requestToken = new io.intino.alexandria.ui.services.auth.Token(){

                    public String id() {
                        return UUID.randomUUID().toString();
                    }

                    public String secret() {
                        return "";
                    }
                };
                this.accessToken = null;
                return this.requestToken;
            }

            public URL authenticationUrl(io.intino.alexandria.ui.services.auth.Token token) throws CouldNotObtainAuthorizationUrl {
                try {
                    if (this.requestToken != token) {
                        return null;
                    }
                    return new URL(this.authService.getAuthorizationUrl(AmidasAzureAccessor.this.token(Optional.of(token))));
                }
                catch (Exception exception) {
                    throw new CouldNotObtainAuthorizationUrl(exception);
                }
            }

            public io.intino.alexandria.ui.services.auth.Token accessToken() {
                return this.accessToken;
            }

            public io.intino.alexandria.ui.services.auth.Token accessToken(Verifier verifier) throws CouldNotObtainAccessToken {
                try {
                    io.intino.alexandria.restaccessor.core.RestAccessor accessor = new io.intino.alexandria.restaccessor.core.RestAccessor();
                    Response response = accessor.post(AmidasAzureAccessor.this.url(), AmidasAzureAccessor.this.tokenPath(), AmidasAzureAccessor.this.tokenRequestParameters(verifier.value()));
                    if (response.code() != 200) {
                        throw new CouldNotObtainAccessToken(new Exception(response.code() + " in " + AmidasAzureAccessor.this.tokenUrl() + " Basic " + AmidasAzureAccessor.this.encodeClientIdAndSecret()));
                    }
                    final Map map = (Map)new Gson().fromJson(response.content(), Map.class);
                    this.accessToken = new io.intino.alexandria.ui.services.auth.Token(){

                        public String id() {
                            return (String)map.get("access_token");
                        }

                        public String secret() {
                            return "";
                        }
                    };
                }
                catch (Exception e) {
                    throw new CouldNotObtainAccessToken(e);
                }
                return this.accessToken;
            }

            public void invalidate() throws CouldNotInvalidateAccessToken {
                try {
                    AmidasAzureAccessor.this.api.get(AmidasAzureAccessor.this.url(), AmidasAzureAccessor.this.logoutPath(), AmidasAzureAccessor.this.logoutRequestParameters());
                    AmidasAzureAccessor.this.userInfo = null;
                }
                catch (Exception exception) {
                    throw new CouldNotInvalidateAccessToken(exception);
                }
            }

            public AuthService.Authentication.Version version() {
                return AuthService.Authentication.Version.OAuth2;
            }
        };
    }

    public boolean valid(io.intino.alexandria.ui.services.auth.Token token) {
        if (token == null) {
            return false;
        }
        return this.loadUserInfo(token).containsKey("email");
    }

    public FederationInfo info(io.intino.alexandria.ui.services.auth.Token accessToken) {
        return new FederationInfo(){

            public String name() {
                return "azure";
            }

            public String title() {
                return "Azure federation";
            }

            public String subtitle() {
                return null;
            }

            public URL logo() {
                return null;
            }

            public URI pushServerUri() {
                return null;
            }
        };
    }

    public UserInfo me(io.intino.alexandria.ui.services.auth.Token token) throws CouldNotObtainInfo {
        this.userInfo = this.userInfo(this.loadUserInfo(token));
        return this.userInfo;
    }

    public void logout(io.intino.alexandria.ui.services.auth.Token accessToken) {
    }

    public String logoutUrl() {
        return String.valueOf(this.url()) + this.logoutPath();
    }

    public void addPushListener(io.intino.alexandria.ui.services.auth.Token accessToken, AuthService.FederationNotificationListener listener) throws CouldNotObtainInfo {
    }

    private Token token(Optional<io.intino.alexandria.ui.services.auth.Token> token) {
        if (!token.isPresent()) {
            return null;
        }
        return new Token(token.get().id(), "");
    }

    private OAuthService authService() throws SpaceAuthCallbackUrlIsNull {
        ServiceBuilder builder = new ServiceBuilder().provider(this.apiOf()).apiKey(this.property(ClientId)).apiSecret(this.property(ClientSecret));
        URL callbackUrl = this.callbackUrl(this.space);
        if (callbackUrl == null) {
            throw new SpaceAuthCallbackUrlIsNull();
        }
        builder.callback(callbackUrl.toString());
        return builder.build();
    }

    private Api apiOf() {
        return new DefaultApi20(){

            public String getAccessTokenEndpoint() {
                return AmidasAzureAccessor.this.tokenUrl();
            }

            public String getAuthorizationUrl(OAuthConfig oAuthConfig) {
                return String.valueOf(AmidasAzureAccessor.this.url()) + String.format(AmidasAzureAccessor.AuthorizationUrl, AmidasAzureAccessor.this.property(AmidasAzureAccessor.TenantId), AmidasAzureAccessor.this.property(AmidasAzureAccessor.ClientId), AmidasAzureAccessor.this.callbackUrl(AmidasAzureAccessor.this.space), AmidasAzureAccessor.Scope, AmidasAzureAccessor.CodeVerifier);
            }
        };
    }

    private String tokenUrl() {
        return String.valueOf(this.url()) + this.tokenPath();
    }

    private String tokenPath() {
        return String.format(TokenPath, this.property(TenantId));
    }

    private Map<String, String> tokenRequestParameters(final String code) {
        final URL redirectUri = this.callbackUrl(this.space);
        return new HashMap<String, String>(){
            {
                this.put("code", code);
                this.put("client_id", AmidasAzureAccessor.this.property(AmidasAzureAccessor.ClientId));
                this.put("scope", AmidasAzureAccessor.Scope);
                this.put("redirect_uri", redirectUri != null ? redirectUri.toString() : "");
                this.put("grant_type", "authorization_code");
                this.put("code_verifier", AmidasAzureAccessor.CodeVerifier);
                this.put("client_secret", AmidasAzureAccessor.this.property(AmidasAzureAccessor.ClientSecret));
            }
        };
    }

    private String logoutPath() {
        return String.format(LogoutPath, this.property(TenantId), this.property(ClientId), this.space().url().toString());
    }

    private Map<String, String> logoutRequestParameters() {
        return new HashMap<String, String>(){
            {
                this.put("client_id", AmidasAzureAccessor.this.property(AmidasAzureAccessor.ClientId));
                this.put("post_logout_redirect_uri", AmidasAzureAccessor.this.space().url().toString());
            }
        };
    }

    private String revokePath() {
        return String.format(RevokePath, this.property(TenantId), this.property(ClientId), this.space().url().toString());
    }

    private URL callbackUrl(Space space) {
        try {
            return new URL(this.space().url().toString() + "/authenticate-callback");
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private UserInfo userInfo(final Map<String, Object> map) {
        return new UserInfo(){

            public String username() {
                return map.get("email").toString();
            }

            public String fullName() {
                return map.get("name").toString();
            }

            public URL photo() {
                return null;
            }

            public String email() {
                return "";
            }

            public String language() {
                return "es";
            }

            public List<String> roleList() {
                return Collections.emptyList();
            }
        };
    }

    public UserInfo userInfo() {
        return this.userInfo;
    }

    private String encodeClientIdAndSecret() {
        return Base64.getEncoder().encodeToString((this.property(ClientId) + ":" + this.property(ClientSecret)).getBytes());
    }

    private Map<String, Object> loadUserInfo(io.intino.alexandria.ui.services.auth.Token token) {
        HttpGet get = new HttpGet(this.property(GraphUrl) + "/oidc/userinfo");
        get.setHeader("Authorization", "Bearer " + token.id());
        try {
            String line;
            CloseableHttpClient client = HttpClientFactory.client();
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                return Collections.emptyMap();
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuilder result = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            return (Map)new Gson().fromJson(result.toString(), Map.class);
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
    }

    private String property(String name) {
        return (String)this.configuration.property(name);
    }

    public static class HttpClientFactory {
        public static CloseableHttpClient client() throws IOException {
            try {
                SSLContextBuilder builder = new SSLContextBuilder();
                builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                Registry registry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
                cm.setMaxTotal(100);
                return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).setConnectionManager((HttpClientConnectionManager)cm).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new IOException("Error getting client");
            }
        }
    }
}

