package io.intino.amidas.accessor.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class Configuration {
	private final Properties properties;

	public static final String Type = "federation.type";
	public static final String Url = "federation.url";

	public Provider provider() {
		return Provider.from(property(Type));
	}

	public URL url() {
		return urlOf(property(Url));
	}

	public Configuration(Properties properties) {
		this.properties = properties;
	}

	@SuppressWarnings("unchecked")
	public <T> T property(String name) {
		return (T) properties.get(name);
	}

	private URL urlOf(String value) {
		try {
			return new URL(value);
		} catch (MalformedURLException e) {
			return null;
		}
	}

}
