package io.intino.amidas.accessor.adapters.response;

import io.intino.amidas.accessor.core.Device;
import io.intino.amidas.accessor.core.User;
import com.google.gson.JsonObject;

public class DeviceResponseAdapter extends ObjectResponseAdapter<Device> {

    @Override
    protected Device adapt(JsonObject element) {
        return new Device() {
            @Override
            public String id() {
                return element.get("id").getAsString();
            }

            @Override
            public User user() {
                return new UserResponseAdapter().adapt(element.get("user"));
            }
        };
    }

}
